/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice;

import csbase.exception.InitFailureException;
import csbase.exception.OperationFailureException;
import csbase.exception.PermissionException;
import csbase.exception.ServiceFailureException;
import csbase.exception.algorithms.AlgorithmValidationException;
import csbase.logic.AlgorithmExecutionPermission;
import csbase.logic.CategoryAlgorithmsExecutionPermission;
import csbase.logic.CommandFailedNotification;
import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;
import csbase.logic.CommandKilledNotification;
import csbase.logic.CommandStatus;
import csbase.logic.CommandSubmission;
import csbase.logic.FailureFinalizationType;
import csbase.logic.Priority;
import csbase.logic.SchedulerStateChangedEvent;
import csbase.logic.SimpleCommandFinalizationInfo;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.CategorySet;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.flows.configurator.Node;
import csbase.logic.algorithms.serializer.exception.AlgorithmConfigurationSerializerException;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationMode;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.RemoteObserver;
import csbase.remote.SchedulerServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.algorithmservice.AlgorithmService;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import csbase.server.services.messageservice.MessageService;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.schedulerservice.CommandIdGeneratorInterface;
import csbase.server.services.schedulerservice.PriorityQueue;
import csbase.server.services.schedulerservice.Scheduler;
import csbase.server.services.sgaservice.SGAService;
import csbase.util.messages.Message;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class SchedulerService
extends Service
implements SchedulerServiceInterface {
    private CommandIdGeneratorInterface commandIdGenerator;
    private int commandIdRetries;
    private int submissionRetries;
    private PriorityQueue commandQueue;
    private Scheduler scheduler;
    private static final String QUARANTINE_PROPERTY = "sga.quarantine.time";
    private static final String PROCESSING_INTERVAL_PROPERTY = "processing.interval";
    private static final String SCHED_POLICY_PROPERTY = "sga.schedule.policy";
    private static final String RESOURCES_CONTROL_PROPERTY = "sga.resources.control";
    private static final String COMMAND_ID_GENERATOR_PROPERTY = "command.id.generator";
    private static final String COMMAND_ID_RETRIES_PROPERTY = "command.id.retries";
    private static final String COMMAND_SUBMISSION_RETRIES_PROPERTY = "command.submission.retries";
    private static final String RESOURCES_BACKUP_FILE_NAME = "resources-backup.dat";
    private static final String BACKUP_FILE_NAME = "queue-backup.dat";
    private static final String ABBREV_DEFAULT = "abbr";
    private static final int ABBREV_LENGTH = 4;
    private static final String SYSNAME_DEFAULT = "C";
    private static final int SYSNAME_LENGTH = 1;
    private static final String USERID_DEFAULT = "user";
    private static final int USERID_LENGTH = 4;
    private static boolean resourcesControl;
    private static String resourcesBackupFilename;
    private MessageService messageService;
    private final Map<ExecutionType, Integer> exeTypeCounter = new TreeMap<ExecutionType, Integer>();
    private final Map<String, Integer> algoNameCounter = new TreeMap<String, Integer>();
    private final Map<String, Integer> flowAlgoNameCounter = new TreeMap<String, Integer>();
    private final Map<String, Integer> userExeCounter = new TreeMap<String, Integer>();
    private int flowExecutionCounter;

    protected SchedulerService() throws ServerException {
        super("SchedulerService");
        ClientRemoteLocator.schedulerService = this;
    }

    @Deprecated
    public Set<CommandInfo> submitCommand(CommandSubmission commandSubmission, RemoteObserver ... observers) throws RemoteException {
        return this.submitCommand(commandSubmission);
    }

    public Set<CommandInfo> submitCommand(CommandSubmission submission) throws RemoteException {
        HashSet<CommandInfo> commands = new HashSet<CommandInfo>();
        switch (submission.getExecutionType()) {
            case SIMPLE: {
                CommandInfo commandInfo = this.createCommand(submission);
                if (submission.isManual()) {
                    String sgaName = (String)submission.getSGANames().get(0);
                    commandInfo.setSGAName(sgaName);
                }
                commands.add(commandInfo);
                this.commandQueue.add(commandInfo);
                break;
            }
            case MULTIPLE: {
                if (submission.isManual()) {
                    int executionCountPerSGA = submission.getExecutionCountPerSGAForMultipleExecution();
                    for (String sgaName : submission.getSGANames()) {
                        for (int i = 0; i < executionCountPerSGA; ++i) {
                            CommandInfo command = this.createCommand(submission);
                            command.setSGAName(sgaName);
                            commands.add(command);
                            this.commandQueue.add(command);
                        }
                    }
                } else {
                    int executionCount = submission.getExecutionCountForMultipleExecution();
                    for (int i = 0; i < executionCount; ++i) {
                        CommandInfo command = this.createCommand(submission);
                        commands.add(command);
                        this.commandQueue.add(command);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Tipo de execu\u00e7\u00e3o inv\u00e1lida.");
            }
        }
        return commands;
    }

    private CommandInfo createCommand(CommandSubmission submission) {
        Object userId = Service.getUser().getId();
        String systemId = Service.getSystemId();
        String submissionInfo = submission + "usu\u00e1rio: " + userId;
        if (systemId != null) {
            submissionInfo = submissionInfo + " - Sistema origem do comando: " + systemId;
        }
        try {
            Server.logInfoMessage(submissionInfo);
            AlgorithmConfigurator configurator = submission.createAlgorithmConfigurator();
            this.checkExecutionAlgorithmPermission(configurator);
            this.checkParameterValues(configurator, submission.getProjectId(), userId);
            this.collectExeTypeStats(submission, configurator);
            this.collectAlgoNameStats(configurator);
            this.incrCounter(this.userExeCounter, Service.getUser().getLogin());
            String serverName = Server.getInstance().getSystemName();
            String abbrev = configurator.getAbbreviation();
            if (abbrev == null) {
                String projectName;
                ProjectService projectService = ProjectService.getInstance();
                abbrev = projectName = projectService.getProjectName(submission.getProjectId());
            }
            String user = userId.toString();
            CommandPersistenceService service = CommandPersistenceService.getInstance();
            String commandId = null;
            int retries = this.commandIdRetries;
            boolean createNewCommandId = true;
            while (createNewCommandId) {
                commandId = this.createCommandId(user, abbrev, serverName);
                try {
                    service.createUniqueCommandDirectory(submission.getProjectId(), commandId);
                    createNewCommandId = false;
                }
                catch (ServiceFailureException sfe) {
                    if (--retries == 0) {
                        Server.logSevereMessage("Ocorreu um erro ao criar o diret\u00f3rio do comando no servi\u00e7o de persist\u00eancia. O diret\u00f3rio j\u00e1 existe.", sfe);
                        throw new ServiceFailureException("Falha na submiss\u00e3o de comando. Ocorreu um erro ao criar o diret\u00f3rio do comando no servi\u00e7o de persist\u00eancia" + submissionInfo, (Throwable)sfe);
                    }
                    Server.logFineMessage(String.format("Diret\u00f3rio do comando %s j\u00e1 existe no servi\u00e7o de persist\u00eancia. Criando novo identificador...", commandId));
                }
            }
            CommandInfo command = new CommandInfo(commandId, configurator, submission, user, submission.getExtraInfoMap());
            service.saveCommandInfo(command);
            return command;
        }
        catch (AlgorithmValidationException e) {
            Validation validationResult = e.getValidationResult();
            String message = "Falha na submiss\u00e3o de comando. Ocorreu um erro ao validar os par\u00e2metros do comando. ";
            if (validationResult != null) {
                message = message + "\n" + validationResult.getMessage();
            }
            Server.logSevereMessage(message, e);
            throw e;
        }
        catch (OperationFailureException e) {
            Server.logSevereMessage("Ocorreu um erro ao salvar o comando no servi\u00e7o de persist\u00eancia", e);
            throw new ServiceFailureException("Falha na submiss\u00e3o de comando. Ocorreu um erro ao salvar o comando no servi\u00e7o de persist\u00eancia" + submissionInfo, (Throwable)e);
        }
        catch (PermissionException pe) {
            Server.logWarningMessage("Ocorreu um erro de permiss\u00e3o. " + pe.getMessage());
            throw pe;
        }
        catch (AlgorithmConfigurationSerializerException e) {
            Server.logSevereMessage("Falha na submiss\u00e3o do comando. Ocorreu um erro na cria\u00e7\u00e3o do configurador a partir do comando.", e);
            throw new ServiceFailureException("Falha na submiss\u00e3o do comando. \nOcorreu um erro na cria\u00e7\u00e3o do configurador a partir do comando. \nVerifique o log para maiores detalhes.", (Throwable)e);
        }
        catch (IOException e) {
            Server.logSevereMessage("Falha na submiss\u00e3o de comando. Ocorreu um erro de I/O na recupera\u00e7\u00e3o do configurador a partir do comando.", e);
            throw new ServiceFailureException("Falha na submiss\u00e3o de comando.  \nOcorreu um erro de I/O na recupera\u00e7\u00e3o do configurador a partir do comando. \nVerifique o log para maiores detalhes.");
        }
        catch (Exception e) {
            Server.logSevereMessage("Falha na submiss\u00e3o do comando: \n" + submissionInfo, e);
            throw new ServiceFailureException("Falha na submiss\u00e3o do comando. \n" + submissionInfo, (Throwable)e);
        }
    }

    private void checkParameterValues(AlgorithmConfigurator configurator, Object projectId, Object userId) throws AlgorithmValidationException {
        try {
            ValidationContext context = new ValidationContext(ValidationMode.FULL, projectId, userId);
            Validation result = configurator.validate(context);
            if (!result.isWellSucceeded()) {
                throw new AlgorithmValidationException(result);
            }
        }
        catch (RemoteException e) {
            throw new AlgorithmValidationException((Throwable)e);
        }
    }

    private void collectExeTypeStats(CommandSubmission submission, AlgorithmConfigurator configurator) {
        this.incrCounter(this.exeTypeCounter, submission.getExecutionType());
        if (configurator.getConfiguratorType() == AlgorithmConfigurator.ConfiguratorType.FLOW) {
            ++this.flowExecutionCounter;
        }
    }

    private void collectAlgoNameStats(AlgorithmConfigurator configurator) {
        AlgorithmConfigurator.ConfiguratorType configuratorType = configurator.getConfiguratorType();
        if (configuratorType == AlgorithmConfigurator.ConfiguratorType.FLOW) {
            FlowAlgorithmConfigurator fconf = (FlowAlgorithmConfigurator)configurator;
            Set nodes = fconf.getNodes();
            for (Node node : nodes) {
                String algoName = node.getConfigurator().getAlgorithmName();
                this.incrCounter(this.flowAlgoNameCounter, algoName);
            }
        } else {
            this.incrCounter(this.algoNameCounter, configurator.getAlgorithmName());
        }
    }

    private String createCommandId(String userId, String abbrev, String sysName) {
        return String.format("%s@%s.%s%s", this.formatField(userId, USERID_DEFAULT, 4, '0'), this.formatField(abbrev, ABBREV_DEFAULT, 4, '0'), this.formatField(sysName, SYSNAME_DEFAULT, 1, '0'), this.commandIdGenerator.generateId());
    }

    private String formatField(String field, String defaultValue, int defaultLength, char defaultChar) {
        StringBuilder result = new StringBuilder(field != null ? field : defaultValue);
        int length = result.length();
        if (length < defaultLength) {
            for (int i = defaultLength - length; i > 0; --i) {
                result.append(defaultChar);
            }
        } else {
            result.setLength(defaultLength);
        }
        return result.toString();
    }

    private void checkExecutionAlgorithmPermission(AlgorithmConfigurator configurator) throws PermissionException, Exception {
        User user = Service.getUser();
        if (user.isAdmin()) {
            return;
        }
        String algorithmName = configurator.getAlgorithmName();
        CategorySet categorySet = AlgorithmService.getInstance().getAllCategories();
        List categoriesFullNames = categorySet.getAlgorithmCategoriesFullNames(algorithmName);
        String systemId = Service.getSystemId();
        String errorMsgFormatter = "Sem permiss\u00e3o para executar{0} {1}: {2}";
        String systemMsg = systemId == null ? "" : " pelo sistema " + systemId;
        String algoMsg = "";
        String errorMsg = "";
        if (configurator.getConfiguratorType() == AlgorithmConfigurator.ConfiguratorType.FLOW) {
            Vector<String> noPermissionAlgorithms = new Vector<String>();
            FlowAlgorithmConfigurator flowConfigurator = (FlowAlgorithmConfigurator)configurator;
            Set nodes = flowConfigurator.getNodes();
            for (Node node : nodes) {
                algorithmName = node.getConfigurator().getAlgorithmName();
                if (AlgorithmExecutionPermission.checkSystemAndAlgorithmExecPermission((User)Service.getUser(), (String)systemId, (String)algorithmName)) continue;
                categoriesFullNames = categorySet.getAlgorithmCategoriesFullNames(algorithmName);
                if (CategoryAlgorithmsExecutionPermission.checkSystemAndCategoriesExecPermission((User)Service.getUser(), (String)systemId, (List)categoriesFullNames)) continue;
                noPermissionAlgorithms.add(algorithmName);
            }
            int nAlgo = noPermissionAlgorithms.size();
            if (noPermissionAlgorithms.isEmpty()) {
                return;
            }
            String algoErrorNames = "";
            for (String algoName : noPermissionAlgorithms) {
                algoErrorNames = algoErrorNames + "\n" + algoName;
            }
            algoMsg = nAlgo == 1 ? "o algoritmo" : " os algoritmos";
            errorMsg = MessageFormat.format(errorMsgFormatter, systemMsg, algoMsg, algoErrorNames);
        } else {
            if (AlgorithmExecutionPermission.checkSystemAndAlgorithmExecPermission((User)Service.getUser(), (String)systemId, (String)algorithmName)) {
                return;
            }
            if (CategoryAlgorithmsExecutionPermission.checkSystemAndCategoriesExecPermission((User)Service.getUser(), (String)systemId, (List)categoriesFullNames)) {
                return;
            }
            algoMsg = "o algoritmo";
            errorMsg = MessageFormat.format(errorMsgFormatter, systemMsg, algoMsg, "\n" + algorithmName);
        }
        throw new PermissionException(errorMsg);
    }

    public boolean setPosition(Object commandId, int position) {
        Server.logFineMessage("Altera\u00e7\u00e3o da posica\u00e7\u00e3o do comando " + commandId + " para " + position);
        if (position < 0 || position >= this.commandQueue.size()) {
            return false;
        }
        return this.commandQueue.setPosition(commandId, position);
    }

    public boolean setPriority(Object commandId, Priority priority) {
        Server.logFineMessage("Altera\u00e7\u00e3o da prioridade do comando " + commandId + " para " + priority);
        return this.commandQueue.setPriority(commandId, priority);
    }

    public void updateCommandDescription(String commandId, String description) {
        for (CommandInfo scheduledCommand : this.commandQueue.getCommands()) {
            if (!scheduledCommand.getId().equals(commandId)) continue;
            scheduledCommand.setDescription(description);
            return;
        }
    }

    protected void failCommand(CommandInfo cmd, FailureFinalizationType cause) {
        switch (cause) {
            case SGA_IS_NOT_AVAILABLE: {
                CommandInfo info = this.commandQueue.getCommand(cmd.getId());
                info.setStatus(CommandStatus.SCHEDULED);
                if (cmd.isAutomatic()) {
                    cmd.setSGAName(null);
                }
                return;
            }
        }
        cmd.setFinished((CommandFinalizationInfo)new SimpleCommandFinalizationInfo(CommandFinalizationType.FAILED, cause));
        CommandPersistenceService service = CommandPersistenceService.getInstance();
        if (service != null && cause != FailureFinalizationType.PROJECT_NOT_FOUND) {
            try {
                service.saveCommandInfo(cmd);
            }
            catch (OperationFailureException e) {
                Server.logSevereMessage("Ocorreu um erro ao salvar o comando " + cmd.getId() + "com o status FAILED no servi\u00e7o de persist\u00eancia", e);
            }
        }
        this.notifyCommandFailed(cmd, cause);
    }

    private void notifyCommandFailed(CommandInfo command, FailureFinalizationType cause) {
        Object userId = null;
        try {
            userId = command.getUserId();
            CommandFailedNotification notData = new CommandFailedNotification(this.getSenderName(), (Object)command.getId(), command.getDescription(), command.getTip(), command.getSubmittedDate().getTime(), null, command.getProjectId(), (CommandFinalizationInfo)new SimpleCommandFinalizationInfo(CommandFinalizationType.FAILED, cause));
            this.messageService.send(new Message((Serializable)notData), (String)userId);
        }
        catch (Exception e) {
            Server.logSevereMessage("Imposs\u00edvel notificar o usu\u00e1rio (" + userId + ") " + "sobre a falha do comando (" + command.getId() + ")", e);
        }
    }

    private void notifyCommandKilled(CommandInfo command) {
        CommandKilledNotification notData = new CommandKilledNotification(this.getSenderName(), (Object)command.getId(), command.getDescription(), command.getTip(), command.getSubmittedDate().getTime(), null, command.getProjectId(), command.getFinalizationInfo());
        try {
            String[] users = ProjectService.getInstance().getUserToNotify(command.getProjectId());
            this.messageService.send(new Message((Serializable)notData), users);
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro ao notificar os usu\u00e1rios do projeto " + command.getProjectId() + " sobre o cancelamento da execu\u00e7\u00e3o do comando (" + command.getId() + ")", e);
        }
    }

    public boolean removeCommand(Object commandId) {
        Server.logFineMessage("Remo\u00e7\u00e3o do comando : " + commandId);
        try {
            CommandInfo cmd = this.commandQueue.remove(commandId);
            if (null == cmd) {
                return false;
            }
            ProjectService projectService = ProjectService.getInstance();
            Object projectId = cmd.getProjectId();
            Object commandOwnerId = cmd.getUserId();
            Object projectOwnerId = projectService.getOwnerId(projectId);
            User loggedUser = Service.getUser();
            Object loggedUserId = loggedUser.getId();
            if (!(loggedUser.isAdmin() || loggedUserId.equals(commandOwnerId) || loggedUserId.equals(projectOwnerId))) {
                throw new PermissionException();
            }
            cmd.setFinished((CommandFinalizationInfo)new SimpleCommandFinalizationInfo(CommandFinalizationType.KILLED, false));
            CommandPersistenceService service = CommandPersistenceService.getInstance();
            if (service != null) {
                service.saveCommandInfo(cmd);
            }
            this.notifyCommandKilled(cmd);
            return true;
        }
        catch (OperationFailureException e) {
            Server.logSevereMessage("Ocorreu um erro ao salvar o comando com o status KILLED no servi\u00e7o de persist\u00eancia", e);
            throw new ServiceFailureException("Falha na remo\u00e7\u00e3o de comando. Ocorreu um erro ao salvar o comando com o status KILLED no servi\u00e7o de persist\u00eancia", (Throwable)e);
        }
    }

    public void setBlocked(boolean blocked) {
        Server.logFineMessage("Bloqueio da fila chamado: " + blocked);
        this.commandQueue.setBlocked(blocked);
        this.messageService.sendToAll(new Message((Serializable)new SchedulerStateChangedEvent(blocked)));
    }

    public boolean isBlocked() {
        return this.commandQueue.isBlocked();
    }

    public CommandInfo[] getQueuedCommands() {
        Object userId = Service.getUser().getId();
        boolean isAdmin = Service.getUser().isAdmin();
        List<CommandInfo> cmds = this.commandQueue.getCommands();
        ArrayList<CommandInfo> commandsArray = new ArrayList<CommandInfo>();
        for (int i = 0; i < cmds.size(); ++i) {
            if (!isAdmin && !cmds.get(i).getUserId().equals(userId)) continue;
            commandsArray.add(cmds.get(i));
            cmds.get(i).setGlobalPosition(i + 1);
        }
        return commandsArray.toArray(new CommandInfo[0]);
    }

    public static void createService() throws ServerException {
        new SchedulerService();
    }

    @Override
    protected Service[] getInitializationDependencies() {
        return new Service[]{AlgorithmService.getInstance(), CommandPersistenceService.getInstance(), MessageService.getInstance(), ProjectService.getInstance(), SGAService.getInstance()};
    }

    public static final SchedulerService getInstance() {
        return (SchedulerService)SchedulerService.getInstance("SchedulerService");
    }

    @Override
    public final void initService() throws ServerException {
        String backupFilename;
        String schedPolicyName;
        int sgaQuarantine;
        SGAService sgaService = SGAService.getInstance();
        this.messageService = MessageService.getInstance();
        String converterClassName = this.getStringProperty(COMMAND_ID_GENERATOR_PROPERTY);
        try {
            Class<?> commandIdGeneratorClass = Class.forName(converterClassName);
            this.commandIdGenerator = (CommandIdGeneratorInterface)commandIdGeneratorClass.newInstance();
        }
        catch (Exception e) {
            throw new ServerException((Throwable)new InitFailureException("Falha na inicializa\u00e7\u00e3o do gerador de identificadores de comandos.", (Throwable)e));
        }
        long queueProcessingInterval = this.isPropertyNull(PROCESSING_INTERVAL_PROPERTY) ? (long)(sgaService.getUpdateInterval() * 1000 * 2) : (long)this.getIntProperty(PROCESSING_INTERVAL_PROPERTY);
        Server.logInfoMessage("Intervalo de processamento da fila de comandos: " + queueProcessingInterval + " milisegundo(s).");
        this.commandIdRetries = this.isPropertyNull(COMMAND_ID_RETRIES_PROPERTY) ? 1 : this.getIntProperty(COMMAND_ID_RETRIES_PROPERTY);
        Server.logInfoMessage("N\u00famero de vezes que o scheduler tentar\u00e1 gerar um novo comando: " + this.commandIdRetries + " .");
        this.submissionRetries = this.isPropertyNull(COMMAND_SUBMISSION_RETRIES_PROPERTY) ? -1 : this.getIntProperty(COMMAND_SUBMISSION_RETRIES_PROPERTY);
        Server.logInfoMessage("Quantidade m\u00e1xima de tentativas de execu\u00e7\u00e3o de comandos: " + this.submissionRetries + " .");
        try {
            sgaQuarantine = this.getIntProperty(QUARANTINE_PROPERTY);
            Server.logInfoMessage("Intervalo de quarentena dos SGAs: " + sgaQuarantine + " segundo(s).");
        }
        catch (Exception e) {
            throw new ServerException((Throwable)new InitFailureException("Falha na inicializa\u00e7\u00e3o do tempo de quarentena do SGA.", (Throwable)e));
        }
        try {
            schedPolicyName = this.getStringProperty(SCHED_POLICY_PROPERTY);
            Server.logInfoMessage("Pol\u00edtica de escalonamento a ser ativada: " + schedPolicyName + ".");
        }
        catch (Exception e) {
            throw new ServerException((Throwable)new InitFailureException("Falha na inicializa\u00e7\u00e3o da pol\u00edtica de escalonamento.", (Throwable)e));
        }
        try {
            backupFilename = sgaService.getCommandsPersistencyDirectoryName() + File.separator + BACKUP_FILE_NAME;
        }
        catch (OperationFailureException e) {
            throw new ServerException((Throwable)new InitFailureException("Falha na inicializa\u00e7\u00e3o do arquivo para backup.", (Throwable)e));
        }
        Server.logInfoMessage("Arquivo de backup: " + backupFilename);
        this.commandQueue = new PriorityQueue(backupFilename);
        File backupFile = new File(backupFilename);
        if (backupFile.exists()) {
            this.commandQueue.loadFromBackup();
            for (CommandInfo command : this.commandQueue.getCommands()) {
                if (command.getStatus() != CommandStatus.INIT && command.getStatus() != CommandStatus.UPLOADING) continue;
                command.setStatus(CommandStatus.SCHEDULED);
                if (!command.isAutomatic()) continue;
                command.setSGAName(null);
            }
        } else {
            Server.logWarningMessage("Arquivo de backup n\u00e3o encontrado.Fila n\u00e3o recuperada na inicializa\u00e7\u00e3o do servidor.");
        }
        try {
            resourcesControl = this.getBooleanProperty(RESOURCES_CONTROL_PROPERTY);
            if (resourcesControl) {
                Server.logInfoMessage("Controle de recursos ativo.");
                resourcesBackupFilename = sgaService.getCommandsPersistencyDirectoryName() + File.separator + RESOURCES_BACKUP_FILE_NAME;
                Server.logInfoMessage("Arquivo de backup: " + resourcesBackupFilename);
            } else {
                Server.logInfoMessage("Controle de recursos inativo.");
            }
        }
        catch (OperationFailureException e) {
            throw new ServerException((Throwable)new InitFailureException("Falha na inicializa\u00e7\u00e3o do arquivo para backup.", (Throwable)e));
        }
        catch (Exception e) {
            throw new ServerException((Throwable)new InitFailureException("Falha na inicializa\u00e7\u00e3o do controle de recursos de cada SGA.", (Throwable)e));
        }
        this.scheduler = new Scheduler(this.commandQueue, queueProcessingInterval, this.submissionRetries, sgaQuarantine, schedPolicyName, resourcesControl, resourcesBackupFilename);
        this.scheduler.startScheduler();
    }

    @Override
    public void shutdownService() {
        if (this.scheduler != null) {
            this.scheduler.stopScheduler();
        }
        Server.logInfoMessage("Servi\u00e7o encerrado.");
    }

    protected boolean has2Update(Object arg, Object event) {
        return true;
    }

    public Map<ExecutionType, Integer> getExeTypeStats() throws RemoteException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
        return Collections.unmodifiableMap(this.exeTypeCounter);
    }

    public Map<String, Integer> getAlgoStats(boolean flowAlgorithms) throws RemoteException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
        return Collections.unmodifiableMap(flowAlgorithms ? this.flowAlgoNameCounter : this.algoNameCounter);
    }

    public int getFlowExecutionStats() throws RemoteException {
        return this.flowExecutionCounter;
    }

    public Map<String, Integer> getUserStats() throws RemoteException {
        return Collections.unmodifiableMap(this.userExeCounter);
    }

    public static boolean getResourcesControl() {
        return resourcesControl;
    }

    public static String getResourcesBackupFilename() {
        return resourcesBackupFilename;
    }
}

