package csbase.server.services.loginservice;

import csbase.remote.RemoteEvent;

/**
 * Representa um evento que indica que um usurio realizou logout. 
 */
public class LogoutEvent extends RemoteEvent {
  /**
   * @see #LogoutEvent(Object)
   */
  private Object sessionKey;

  /**
   * Cria uma instncia de um evento de logout para um determinado usurio.
   *
   * @param sessionKey Chave que identifica a sesso de um usurio logado.
   */
  public LogoutEvent(Object sessionKey) {
    this.sessionKey = sessionKey;
  }

  /**
   * Getter
   *
   * @return Chave da sesso do usurio.
   *
   * @see #LogoutEvent(Object)
   */
  public final Object getSessionKey() {
    return this.sessionKey;
  }
}
