package csbase.server.services.schedulerservice.filter;

import csbase.exception.PermissionException;
import csbase.logic.SGASet;
import csbase.logic.sga.filter.SGACriteria;
import csbase.server.Service;
import csbase.server.services.sgaservice.SGAService;

public class SGACriteriaByUserPermission implements SGACriteria {

	private Object user;
	private SGAService sgaService;
	
	public SGACriteriaByUserPermission (Object user)
	{
		this.user = user;
		this.sgaService = SGAService.getInstance();
	}
	
	@Override
	public boolean meetCriteria(SGASet server) {
		Service.setUserId(user);
		try {
			sgaService.checkExecutionPermission(server.getName());
		} catch (PermissionException e) {
			return false;
		}
		return true;
	}

}
