package csbase.server.services.schedulerservice.filter;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.logic.sga.filter.SGACriteria;
import csbase.logic.sga.filter.SGACriteriaAnd;
import csbase.logic.sga.filter.SGACriteriaByAvailability;
import csbase.logic.sga.filter.SGAFilter;

import java.util.LinkedList;
import java.util.List;

public class SGASimpleFilter {
	public static List<SGASet> filter(CommandInfo cmd, List<SGASet> servers) {
		SGACriteria availabilityCriteria;
		SGACriteria userPermission;

		// Filtro pela disponibilidade -> obrigatrio
		availabilityCriteria = new SGACriteriaByAvailability();

		// Filtro por permisso do usurio -> obrigatrio
		userPermission = new SGACriteriaByUserPermission(cmd.getUserId());
		
		List<SGACriteria> criteriasToMeet = new LinkedList<SGACriteria>();
		criteriasToMeet.add(availabilityCriteria);
		criteriasToMeet.add(userPermission);
		
		SGACriteria finalCriteria = new SGACriteriaAnd(criteriasToMeet);
		
		return new SGAFilter(finalCriteria).filter(servers);
	}
}
