/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice.classadpolicies;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;
import csbase.server.services.schedulerservice.classadpolicies.ClassAdManager;
import csbase.server.services.schedulerservice.classadpolicies.ClassAdMatchInfo;
import csbase.server.services.schedulerservice.classadpolicies.ClassAdPolicyCommons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClassAdPolicy3
implements SchedulerPolicyInterface {
    @Override
    public Map<CommandInfo, SGASet> chooseServer(List<CommandInfo> commands, List<SGASet> servers) {
        HashMap<String, SGASet> originalServers = new HashMap<String, SGASet>();
        ClassAdManager manager = new ClassAdManager();
        ArrayList<CommandInfo> commandsToResolve = new ArrayList<CommandInfo>(commands);
        ArrayList<SGASet> simulatedServers = new ArrayList<SGASet>(servers);
        HashMap<CommandInfo, SGASet> allocation = new HashMap<CommandInfo, SGASet>();
        ArrayList<ClassAdMatchInfo> matches = new ArrayList<ClassAdMatchInfo>();
        for (SGASet sga : servers) {
            originalServers.put(sga.getName(), sga);
        }
        while (!commandsToResolve.isEmpty()) {
            SGASet sga;
            for (CommandInfo cmd : commandsToResolve) {
                matches.addAll(ClassAdPolicyCommons.getMatchedAds(cmd, simulatedServers, manager));
            }
            if (matches.isEmpty()) break;
            Collections.sort(matches);
            ClassAdMatchInfo winnerAd = (ClassAdMatchInfo)matches.get(0);
            sga = winnerAd.getSGA();
            CommandInfo cmd = winnerAd.getCommand();
            allocation.put(cmd, (SGASet)originalServers.get(sga.getName()));
            commandsToResolve.remove(cmd);
            SGASet updatedSGA = ClassAdPolicyCommons.simulateResourceConsumption(cmd, sga);
            simulatedServers.remove(sga);
            simulatedServers.add(updatedSGA);
            manager.alterSGAAd(updatedSGA);
            matches.clear();
        }
        return allocation;
    }
}

