/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services;

import csbase.exception.BugException;
import csbase.exception.CSBaseRuntimeException;
import csbase.exception.InfoException;
import csbase.exception.ServiceFailureException;
import csbase.logic.User;
import csbase.server.Server;
import csbase.server.Service;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class ServiceInvocationHandler
implements InvocationHandler {
    private final Object sessionKey;
    private final InvocationHandler next;

    public ServiceInvocationHandler(Object sessionKey, InvocationHandler next) {
        this.sessionKey = sessionKey;
        this.next = next;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Service.setKey(this.sessionKey);
            Object object = this.next.invoke(proxy, method, args);
            return object;
        }
        catch (ServiceFailureException fe) {
            this.logException(fe);
            String sid = Service.getSystemId();
            if (sid == null) {
                sid = "null";
            }
            Server.logSevereMessage(String.format("Falha em pedido de mtodo %s do servio %s.", method, sid));
            throw new ServiceFailureException(fe.getClientMessage());
        }
        catch (InfoException ie) {
            throw ie;
        }
        catch (CSBaseRuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            this.logException(t);
            throw new BugException();
        }
        finally {
            Service.setKey(null);
        }
    }

    private void logException(Throwable throwable) {
        User user = Service.getUser();
        Object uid = "null";
        if (user != null) {
            uid = user.getId();
        }
        String msg = "Falha em pedido de servi\u00e7o para usu\u00e1rio: ";
        Server.logSevereMessage("Falha em pedido de servi\u00e7o para usu\u00e1rio: " + uid, throwable);
    }
}

