/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.diagnosticservice.monitors.csfs;

import csbase.logic.diagnosticservice.StatusCode;
import csbase.logic.diagnosticservice.ValidationStatus;
import csbase.server.services.csfsservice.CSFSService;
import csbase.server.services.diagnosticservice.MessageTranslator;
import csbase.server.services.diagnosticservice.monitors.Validation;
import csfs.remote.FileServer;
import csfs.remote.FileServerHelper;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;

public class CSFSConnectionValidation
implements Validation {
    public static final String NAME = "ConnectionValidation";

    @Override
    public ValidationStatus check(Locale locale) {
        Properties props = new Properties();
        props.setProperty("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
        props.setProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
        String host = CSFSService.getInstance().getHost();
        int port = CSFSService.getInstance().getPort();
        String corbalocPattern = CSFSService.getInstance().getCorbalocPattern();
        String corbaloc = MessageFormat.format(corbalocPattern, host, "" + port);
        try {
            ORB orb = ORB.init((String[])null, (Properties)props);
            FileServer fileServer = FileServerHelper.narrow((Object)orb.string_to_object(corbaloc));
            fileServer._non_existent();
            return new ValidationStatus(StatusCode.OK, MessageTranslator.getString("server.csfsmonitor.connection.success", locale));
        }
        catch (TRANSIENT e) {
            return new ValidationStatus(StatusCode.ERROR, MessageTranslator.getString("server.csfsmonitor.connection.error", locale), MessageTranslator.getDetailMessage(e, locale));
        }
        catch (COMM_FAILURE e) {
            return new ValidationStatus(StatusCode.ERROR, MessageTranslator.getString("server.csfsmonitor.communication.error", locale), MessageTranslator.getDetailMessage(e, locale));
        }
        catch (NO_PERMISSION e) {
            return new ValidationStatus(StatusCode.ERROR, MessageTranslator.getString("server.csfsmonitor.permission.error", locale), MessageTranslator.getDetailMessage(e, locale));
        }
        catch (SystemException e) {
            return new ValidationStatus(StatusCode.ERROR, MessageTranslator.getString("server.csfsmonitor.access.error", locale), MessageTranslator.getDetailMessage(e, locale));
        }
        catch (Exception e) {
            return new ValidationStatus(StatusCode.ERROR, MessageTranslator.getString("server.csfsmonitor.connection.error", locale), MessageTranslator.getDetailMessage(e, locale));
        }
    }

    @Override
    public String id() {
        return NAME;
    }

    @Override
    public String[] requires() {
        return new String[]{"CSFSServiceAvailable"};
    }
}

