/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.logadministrationservice;

import csbase.exception.PermissionException;
import csbase.logic.LogFile;
import csbase.logic.LogFileInfo;
import csbase.logic.User;
import csbase.logic.Utilities;
import csbase.logic.diagnosticservice.LogType;
import csbase.remote.LogAdministrationServiceInterface;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.ftcservice.FTCService;
import csbase.server.services.mailservice.MailService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.exception.RequestInternalException;

public class LogAdministrationService
extends Service
implements LogAdministrationServiceInterface {
    Map<String, LogType> logType = new Hashtable<String, LogType>();

    protected LogAdministrationService() throws ServerException {
        super("LogAdministrationService");
    }

    public static LogAdministrationService getInstance() {
        return (LogAdministrationService)LogAdministrationService.getInstance("LogAdministrationService");
    }

    @Override
    protected void initService() throws ServerException {
        Server.logInfoMessage("Iniciando o servi\u00e7o de Admnistra\u00e7\u00e3o de Log!");
        List<String> logTypes = this.getStringListProperty("log.type.name");
        List<String> logDirs = this.getStringListProperty("log.type.dir");
        if (logTypes.size() < logDirs.size()) {
            Server.logSevereMessage("Propriedade com o nome de um tipo de log n\u00e3o definida.");
        }
        if (logTypes.size() > logDirs.size()) {
            Server.logSevereMessage("Propriedade com o diret\u00f3rio de um tipo de log n\u00e3o definida.");
        }
        try {
            for (int i = 0; i < Math.min(logTypes.size(), logDirs.size()); ++i) {
                File dir = new File(logDirs.get(i));
                if (dir.exists()) {
                    this.logType.put(logTypes.get(i), new LogType(logTypes.get(i), dir.getCanonicalPath()));
                    continue;
                }
                Server.logSevereMessage("Diret\u00f3rio " + logDirs.get(i) + " n\u00e3o existe.");
            }
        }
        catch (IOException e) {
            Server.logSevereMessage("Erro ao ler o diret\u00f3rio da propriedade LogAdministrationService.log.type.dir.");
        }
    }

    @Override
    protected void shutdownService() throws ServerException {
    }

    protected boolean has2Update(Object arg, Object event) {
        return false;
    }

    public static void createService() throws ServerException {
        new LogAdministrationService();
    }

    public LogType[] getLogTypes() throws RemoteException {
        List<String> typeList = this.getStringListProperty("log.type.name");
        LinkedList<LogType> logTypeList = new LinkedList<LogType>();
        for (String type : typeList) {
            if (!this.logType.containsKey(type)) continue;
            logTypeList.add(this.logType.get(type));
        }
        return logTypeList.toArray(new LogType[0]);
    }

    public LogFileInfo[] listLogFiles(String type, String path) throws RemoteException {
        String initialPath = this.logType.get((Object)type).dir;
        if (initialPath.startsWith(path) && path.length() < initialPath.length()) {
            return null;
        }
        File dir = new File(path);
        ArrayList<LogFileInfo> filenames = new ArrayList<LogFileInfo>();
        for (File file : dir.listFiles()) {
            try {
                filenames.add(new LogFileInfo(file.getName(), file.isDirectory(), file.getCanonicalPath(), file.length(), file.lastModified()));
            }
            catch (IOException e) {
                Server.logSevereMessage("N\u00e3o foi poss\u00edvel listar os arquivos de log");
                e.printStackTrace();
            }
        }
        return filenames.toArray(new LogFileInfo[filenames.size()]);
    }

    private File zipFiles(String zipFileName, List<File> files) {
        try {
            ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(zipFileName));
            for (File file : files) {
                this.addToZip(zipOut, file, "");
            }
            zipOut.close();
            return new File(zipFileName);
        }
        catch (IOException e) {
            throw new RequestInternalException("Erro no envio de logs", (Throwable)e);
        }
    }

    private void addToZip(ZipOutputStream zipOut, File file, String relativePath) throws IOException {
        if (file.isDirectory()) {
            String[] children = file.list();
            if (children.length == 0) {
                zipOut.putNextEntry(new ZipEntry(relativePath + file.getName() + File.separator));
            } else {
                for (String child : children) {
                    this.addToZip(zipOut, new File(file.getAbsolutePath() + File.separator + child), relativePath + file.getName() + File.separator);
                }
            }
        } else {
            FileInputStream in = new FileInputStream(file);
            zipOut.putNextEntry(new ZipEntry(relativePath + file.getName()));
            byte[] data = new byte[in.available()];
            in.read(data);
            zipOut.write(data);
            zipOut.closeEntry();
            in.close();
        }
    }

    private String getZipFileName() {
        String zipFileName = Server.getInstance().getHostName() + "_" + Utilities.getFormattedDate((Date)new Date(), (String)"yyyyMMddHHmmss");
        String tempDir = System.getProperty("java.io.tmpdir");
        if (!tempDir.endsWith("/") && !tempDir.endsWith("\\")) {
            tempDir = tempDir.concat(System.getProperty("file.separator"));
        }
        zipFileName = tempDir.concat(zipFileName).concat(".zip");
        return zipFileName;
    }

    private File[] makeAttachement(String[] filesPaths) {
        ArrayList<File> logFiles = new ArrayList<File>();
        for (String filePath : filesPaths) {
            logFiles.add(new File(filePath));
        }
        String zipFileName = this.getZipFileName();
        File zipFile = this.zipFiles(zipFileName, logFiles);
        return new File[]{zipFile};
    }

    public boolean sendlLogFilesToSuport(String body, String[] filesPaths) {
        MailService mailService = MailService.getInstance();
        if (filesPaths.length == 0) {
            return mailService.mailSupport(body);
        }
        return mailService.mailSupport(body, this.makeAttachement(filesPaths));
    }

    public boolean sendlLogFilesToAdmin(String body, String[] filesPaths) {
        MailService mailService = MailService.getInstance();
        Vector ids = new Vector();
        try {
            ids.addAll(User.getAdminIds());
        }
        catch (Exception e) {
            Server.logSevereMessage("Erro ao obter a lista de usu\u00e1rios adminstradores.", e);
        }
        if (filesPaths.length == 0) {
            return mailService.mailSomeUsers(null, ids.toArray(new Object[0]), body);
        }
        return mailService.mailSomeUsers(null, ids.toArray(new Object[0]), body, this.makeAttachement(filesPaths));
    }

    protected void checkDownloadLogFilePermission() throws PermissionException {
        if (!Service.getUser().isAdmin()) {
            throw new PermissionException();
        }
    }

    public LogFile[] downloadLogFile(String[] paths) throws RemoteException {
        this.checkDownloadLogFilePermission();
        LinkedList<LogFile> files = new LinkedList<LogFile>();
        for (String path : paths) {
            try {
                files.add(this.createLogFile(new File(path)));
            }
            catch (Exception e) {
                Server.logWarningMessage("Erro ao exportar arquivo de log " + path);
            }
        }
        return files.toArray(new LogFile[files.size()]);
    }

    LogFile createLogFile(File file) throws Exception {
        RemoteFileChannelInfo channel = null;
        LogFile[] children = new LogFile[]{};
        if (file.isDirectory()) {
            LinkedList<LogFile> childrenList = new LinkedList<LogFile>();
            for (File f : file.listFiles()) {
                childrenList.add(this.createLogFile(f));
            }
            children = childrenList.toArray(new LogFile[childrenList.size()]);
        } else {
            FTCService ftcService = FTCService.getInstance();
            Server.logInfoMessage("Criando FileChannelInfo: LogAdministrationService");
            channel = ftcService.createFileChannelInfo(file, true);
        }
        return new LogFile(file.getName(), file.isDirectory(), channel, children);
    }
}

