/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.opendreamsservice.algorithm.v1_0;

import csbase.exception.algorithms.AlgorithmNotFoundException;
import csbase.logic.AlgorithmExecutionPermission;
import csbase.logic.CategoryAlgorithmsExecutionPermission;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmOutline;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.CategorySet;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.flows.configurator.Node;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationListParameter;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.HiddenParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.server.Server;
import csbase.server.Service;
import csbase.server.services.ftcservice.FTCService;
import csbase.server.services.openbusservice.OpenBusService;
import csbase.server.services.opendreamsservice.algorithm.v1_0.ParameterMapping;
import java.io.File;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.openbus.algorithmservice.v1_0.AlgorithmBasicInfo;
import tecgraf.openbus.algorithmservice.v1_0.AlgorithmDetailedInfo;
import tecgraf.openbus.algorithmservice.v1_0.AlgorithmDoesNotExistsException;
import tecgraf.openbus.algorithmservice.v1_0.AlgorithmServicePOA;
import tecgraf.openbus.algorithmservice.v1_0.AlgorithmType;
import tecgraf.openbus.algorithmservice.v1_0.AuthorizationException;
import tecgraf.openbus.algorithmservice.v1_0.Configurator;
import tecgraf.openbus.algorithmservice.v1_0.ConfiguratorErrorException;
import tecgraf.openbus.algorithmservice.v1_0.ExecutionType;
import tecgraf.openbus.algorithmservice.v1_0.FTCFile;
import tecgraf.openbus.algorithmservice.v1_0.FlowConfiguratorImpl;
import tecgraf.openbus.algorithmservice.v1_0.FlowNode;
import tecgraf.openbus.algorithmservice.v1_0.NoPermissionException;
import tecgraf.openbus.algorithmservice.v1_0.Program;
import tecgraf.openbus.algorithmservice.v1_0.Property;
import tecgraf.openbus.algorithmservice.v1_0.SimpleConfigurator;
import tecgraf.openbus.algorithmservice.v1_0.SimpleConfiguratorImpl;
import tecgraf.openbus.algorithmservice.v1_0.UserDoesNotExistsException;
import tecgraf.openbus.algorithmservice.v1_0.Version;
import tecgraf.openbus.algorithmservice.v1_0.VersionDoesNotExistsException;
import tecgraf.openbus.algorithmservice.v1_0.parameters.EnumerationListParameterImpl;
import tecgraf.openbus.algorithmservice.v1_0.parameters.EnumerationParameterImpl;
import tecgraf.openbus.algorithmservice.v1_0.parameters.RawValueParameterHelper;

public class AlgorithmService
extends AlgorithmServicePOA {
    private static final String ERROR_VERSION_NOT_FOUND = "A vers\u00e3o {0} do algoritmo {1} n\u00e3o est\u00e1 cadastrada no sistema.";
    private static final String ERROR_ALGO_NOT_FOUND = "O algoritmo {0} n\u00e3o est\u00e1 cadastrado no sistema.";
    private static final String ERROR_CONF_VERSION_NOT_FOUND = "Ocorreu um erro ao criar o configurador do algoritmo {0}.";
    private static final String ERROR_NO_PERMISSION = "O usu\u00e1rio {0} n\u00e3o tem permiss\u00e3o par executar o algoritmo {1}.";
    private static final String ERROR_USER_NOT_EXISTS = "Usu\u00e1rio {0} n\u00e3o existe no CSBase.";
    private final csbase.server.services.algorithmservice.AlgorithmService algorithmService;
    private final FTCService ftcService = FTCService.getInstance();

    public AlgorithmService() {
        this.algorithmService = csbase.server.services.algorithmservice.AlgorithmService.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlgorithmBasicInfo[] getAlgorithms() throws AuthorizationException {
        AlgorithmOutline[] algoOutlineList = this.algorithmService.getAllOutlines();
        Hashtable<String, AlgorithmBasicInfo> permittedAlgorithms = new Hashtable<String, AlgorithmBasicInfo>();
        CategorySet categorySet = this.algorithmService.getAllCategories();
        String sessionUser = OpenBusService.getInstance().initCSBaseAccess();
        try {
            User user = User.getUserByLogin((String)sessionUser);
            if (user == null) {
                throw new AuthorizationException(this.getUserNotExistsMessage(sessionUser));
            }
            for (AlgorithmOutline algo : algoOutlineList) {
                if (AlgorithmExecutionPermission.checkSystemAndAlgorithmExecPermission((User)user, (String)Service.getSystemId(), (String)algo.getName()) && !permittedAlgorithms.containsKey(algo.getName())) {
                    permittedAlgorithms.put(algo.getName(), this.createAlgorithmInfo(algo));
                }
                List categoriesFullNames = categorySet.getAlgorithmCategoriesFullNames(algo.getName());
                if (!CategoryAlgorithmsExecutionPermission.checkSystemAndCategoriesExecPermission((User)user, (String)Service.getSystemId(), (List)categoriesFullNames) || permittedAlgorithms.containsKey(algo.getName())) continue;
                permittedAlgorithms.put(algo.getName(), this.createAlgorithmInfo(algo));
            }
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            Server.logInfoMessage("Erro na recupera\u00e7\u00e3o de permiss\u00e3o durante a busca dos algoritmos para o usu\u00e1rio " + sessionUser + ".");
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
        return permittedAlgorithms.values().toArray(new AlgorithmBasicInfo[permittedAlgorithms.size()]);
    }

    public AlgorithmDetailedInfo getAlgorithmDetail(String algorithmName) throws AlgorithmDoesNotExistsException, NoPermissionException, ConfiguratorErrorException, AuthorizationException {
        AlgorithmDetailedInfo algorithmInfoDetail = new AlgorithmDetailedInfo();
        String sessionUser = OpenBusService.getInstance().initCSBaseAccess();
        try {
            if (!this.checkUserPermission(algorithmName, sessionUser)) {
                throw new NoPermissionException(this.getNoPermissionErrorMessage(algorithmName, sessionUser));
            }
            algorithmInfoDetail = this.getDelailInfo(algorithmName);
        }
        catch (UserDoesNotExistsException e) {
            throw new AuthorizationException(this.getUserNotExistsMessage(sessionUser));
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
        return algorithmInfoDetail;
    }

    public AlgorithmDetailedInfo[] getAlgorithmsDetails(String[] algorithmNameList) throws AlgorithmDoesNotExistsException, NoPermissionException, ConfiguratorErrorException, AuthorizationException {
        Vector<AlgorithmDetailedInfo> algorithmDetailedInfoList = new Vector<AlgorithmDetailedInfo>();
        for (String algorithmName : algorithmNameList) {
            AlgorithmDetailedInfo algoDetail = this.getAlgorithmDetail(algorithmName);
            if (algoDetail == null) continue;
            algorithmDetailedInfoList.add(algoDetail);
        }
        return algorithmDetailedInfoList.toArray(new AlgorithmDetailedInfo[algorithmDetailedInfoList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkUserPermission(String algorithmName, String userId) throws UserDoesNotExistsException, AlgorithmDoesNotExistsException {
        boolean hasPermission = false;
        CategorySet categorySet = this.algorithmService.getAllCategories();
        try {
            OpenBusService.getInstance().initCSBaseAccess();
            User user = User.getUserByLogin((String)userId);
            if (user == null) {
                throw new UserDoesNotExistsException("Usu\u00e1rio " + userId + " n\u00e3o existe.");
            }
            AlgorithmInfo logicAlgorithmInfo = AlgorithmInfo.getAlgorithmInfo((String)algorithmName);
            if (logicAlgorithmInfo == null) {
                throw new AlgorithmDoesNotExistsException(this.getAlgoNotFoundMessage(algorithmName));
            }
            hasPermission = AlgorithmExecutionPermission.checkSystemAndAlgorithmExecPermission((User)user, (String)Service.getSystemId(), (String)algorithmName);
            List categoriesFullNames = categorySet.getAlgorithmCategoriesFullNames(algorithmName);
            hasPermission = hasPermission || CategoryAlgorithmsExecutionPermission.checkSystemAndCategoriesExecPermission((User)user, (String)Service.getSystemId(), (List)categoriesFullNames);
        }
        catch (Exception e) {
            Server.logInfoMessage("Erro ao recuperar permiss\u00e3o do usu\u00e1rio " + userId + " para o algoritmo " + algorithmName + ".");
        }
        finally {
            OpenBusService.getInstance().finishCSBaseAccess();
        }
        return hasPermission;
    }

    public Configurator getConfigurator(String algorithmName, String algorithmVersion) throws ConfiguratorErrorException, VersionDoesNotExistsException, AlgorithmDoesNotExistsException, AuthorizationException {
        String sessionUser = OpenBusService.getInstance().initCSBaseAccess();
        try {
            User user = User.getUserByLogin((String)sessionUser);
            if (user == null) {
                throw new AuthorizationException(this.getUserNotExistsMessage(sessionUser));
            }
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfiguratorErrorException();
        }
        try {
            AlgorithmInfo logicAlgorithmInfo = AlgorithmInfo.getAlgorithmInfo((String)algorithmName);
            if (logicAlgorithmInfo == null) {
                throw new AlgorithmDoesNotExistsException(this.getAlgoNotFoundMessage(algorithmName));
            }
            AlgorithmVersionId versionId = AlgorithmVersionId.create((String)algorithmVersion);
            if (versionId == null) {
                throw new VersionDoesNotExistsException(this.getVersionNotFoundMessage(algorithmName, algorithmVersion));
            }
            AlgorithmConfigurator algorithmConfigurator = this.algorithmService.createAlgorithmConfigurator(algorithmName, versionId);
            return this.createConfigurator(algorithmConfigurator);
        }
        catch (AlgorithmDoesNotExistsException e) {
            throw e;
        }
        catch (VersionDoesNotExistsException e) {
            throw e;
        }
        catch (AlgorithmNotFoundException e) {
            throw new VersionDoesNotExistsException(this.getVersionNotFoundMessage(algorithmName, algorithmVersion));
        }
        catch (Exception e) {
            throw new ConfiguratorErrorException(this.getConfiguratorErrorMessage(algorithmName));
        }
    }

    private FTCFile createFTCFile(File file) throws Exception {
        if (file.isDirectory()) {
            throw new Exception("Caminho informado \u00e9 um diret\u00f3rio");
        }
        Server.logInfoMessage("Criando FileChannelInfo: AlgorithmService");
        RemoteFileChannelInfo channel = this.ftcService.createFileChannelInfo(file, true);
        FTCFile ftcFile = new FTCFile();
        ftcFile.id = channel.getIdentifier();
        ftcFile.host = channel.getHost();
        ftcFile.port = channel.getPort();
        ftcFile.key = channel.getKey();
        return ftcFile;
    }

    private String fillNullStringParam(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    private String getAlgoNotFoundMessage(Object algoId) {
        String msg = ERROR_ALGO_NOT_FOUND;
        Object[] args = new Object[]{algoId};
        return MessageFormat.format(msg, args);
    }

    private String getVersionNotFoundMessage(Object algoId, Object versionId) {
        String msg = ERROR_VERSION_NOT_FOUND;
        Object[] args = new Object[]{versionId, algoId};
        return MessageFormat.format(msg, args);
    }

    private String getConfiguratorErrorMessage(Object algoId) {
        String msg = ERROR_CONF_VERSION_NOT_FOUND;
        Object[] args = new Object[]{algoId};
        return MessageFormat.format(msg, args);
    }

    private String getNoPermissionErrorMessage(Object algoId, Object userId) {
        String msg = ERROR_NO_PERMISSION;
        Object[] args = new Object[]{userId, algoId};
        return MessageFormat.format(msg, args);
    }

    private String getUserNotExistsMessage(Object userId) {
        String msg = ERROR_USER_NOT_EXISTS;
        Object[] args = new Object[]{userId};
        return MessageFormat.format(msg, args);
    }

    private AlgorithmDetailedInfo getDelailInfo(String algorithmName) throws AlgorithmDoesNotExistsException, ConfiguratorErrorException {
        AlgorithmDetailedInfo algorithmInfoDetail = new AlgorithmDetailedInfo();
        AlgorithmInfo logicAlgorithmInfo = null;
        try {
            logicAlgorithmInfo = AlgorithmInfo.getAlgorithmInfo((String)algorithmName);
        }
        catch (Exception e) {
            throw new ConfiguratorErrorException(this.getConfiguratorErrorMessage(algorithmName));
        }
        if (logicAlgorithmInfo == null) {
            throw new AlgorithmDoesNotExistsException(this.getAlgoNotFoundMessage(algorithmName));
        }
        algorithmInfoDetail.name = logicAlgorithmInfo.getName();
        algorithmInfoDetail.description = this.fillNullStringParam(logicAlgorithmInfo.getDescription());
        Vector versionsInfo = logicAlgorithmInfo.getVersions();
        Vector<Version> versions = new Vector<Version>();
        for (AlgorithmVersionInfo vInfo : versionsInfo) {
            try {
                versions.add(this.createAlgorithmVersion(vInfo));
            }
            catch (Exception e) {
                throw new ConfiguratorErrorException(e.getMessage());
            }
            algorithmInfoDetail.versions = new Version[versions.size()];
            versions.toArray(algorithmInfoDetail.versions);
            Hashtable properties = logicAlgorithmInfo.getPropertyValues();
            Vector<Property> algorithmProperties = new Vector<Property>();
            Enumeration keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                Property p = new Property(key, (String)properties.get(key));
                algorithmProperties.add(p);
            }
            algorithmInfoDetail.properties = algorithmProperties.toArray(new Property[algorithmProperties.size()]);
            CategorySet categorySet = this.algorithmService.getAllCategories();
            List categoriesFullNames = categorySet.getAlgorithmCategoriesFullNames(algorithmInfoDetail.name);
            algorithmInfoDetail.categories = categoriesFullNames.toArray(new String[categoriesFullNames.size()]);
        }
        return algorithmInfoDetail;
    }

    private AlgorithmBasicInfo createAlgorithmInfo(AlgorithmOutline algorithmOutline) throws Exception {
        String algorithmName = algorithmOutline.getName();
        AlgorithmInfo logicAlgorithmInfo = AlgorithmInfo.getAlgorithmInfo((String)algorithmName);
        String description = this.fillNullStringParam(logicAlgorithmInfo.getDescription());
        return new AlgorithmBasicInfo(algorithmName, description);
    }

    private Version createAlgorithmVersion(AlgorithmVersionInfo vInfo) throws AlgorithmNotFoundException, ConfiguratorErrorException {
        Version version = new Version();
        AlgorithmVersionId versionId = vInfo.getId();
        version.major = versionId.getMajor();
        version.minor = versionId.getMinor();
        version.patch = versionId.getPatch();
        version.stringValue = versionId.toString();
        Set platforms = vInfo.getPlatformsNames();
        Vector<Program> programs = new Vector<Program>(platforms.size());
        for (String platform : platforms) {
            Program prog = new Program();
            prog.name = platform;
            prog.requirements = new String[]{platform};
            programs.add(prog);
        }
        version.programs = programs.toArray(new Program[programs.size()]);
        try {
            version.configFile = this.createFTCFile(new File(vInfo.getConfiguratorDirPath() + File.separator + "config.xml"));
        }
        catch (Exception e) {
            Server.logInfoMessage("Erro ao acessar aquivo de configura\u00e7\u00e3o do algoritmo " + vInfo.getInfo().getName() + " .");
        }
        return version;
    }

    private Configurator createConfigurator(AlgorithmConfigurator algorithmConfigurator) throws ConfiguratorErrorException {
        SimpleConfiguratorImpl configurator = null;
        switch (algorithmConfigurator.getConfiguratorType()) {
            case SIMPLE: {
                tecgraf.openbus.algorithmservice.v1_0.Parameter param;
                String paramType;
                SimpleAlgorithmConfigurator simpleConfigurator = (SimpleAlgorithmConfigurator)algorithmConfigurator;
                configurator = new SimpleConfiguratorImpl();
                configurator.type = AlgorithmType.ALGORITHM;
                Vector<tecgraf.openbus.algorithmservice.v1_0.Parameter> paramVector = new Vector<tecgraf.openbus.algorithmservice.v1_0.Parameter>();
                for (SimpleParameter simpleParam : simpleConfigurator.getSimpleParameters()) {
                    if (!simpleParam.isEnabled() && simpleParam.ignoreIfDisabled() && !simpleParam.isVisible() && simpleParam.ignoreIfInvisible()) continue;
                    paramType = ParameterMapping.getInstance().getIDLType(simpleParam.getType());
                    if (paramType == null) {
                        paramType = RawValueParameterHelper.id();
                    }
                    param = this.makeParameter((Parameter<?>)simpleParam, paramType);
                    paramVector.add(param);
                }
                for (HiddenParameter hiddenParam : simpleConfigurator.getHiddenParameters()) {
                    paramType = RawValueParameterHelper.id();
                    param = this.makeParameter((Parameter<?>)hiddenParam, paramType);
                    paramVector.add(param);
                }
                tecgraf.openbus.algorithmservice.v1_0.Parameter[] parameters = new tecgraf.openbus.algorithmservice.v1_0.Parameter[paramVector.size()];
                ((SimpleConfigurator)SimpleConfigurator.class.cast((Object)configurator)).parameters = paramVector.toArray(parameters);
                break;
            }
            case FLOW: {
                FlowAlgorithmConfigurator flowConfigurator = (FlowAlgorithmConfigurator)algorithmConfigurator;
                configurator = new FlowConfiguratorImpl();
                configurator.type = AlgorithmType.FLOW;
                Vector<FlowNode> algos = new Vector<FlowNode>();
                for (Node node : flowConfigurator.getNodes()) {
                    FlowNode fNode = new FlowNode();
                    AlgorithmConfigurator nodeConfig = node.getConfigurator();
                    fNode.name = nodeConfig.getAlgorithmName();
                    fNode.id = node.getId();
                    fNode.config = this.createConfigurator(nodeConfig);
                    algos.add(fNode);
                }
                ((FlowConfiguratorImpl)FlowConfiguratorImpl.class.cast((Object)configurator)).algorithms = algos.toArray(new FlowNode[algos.size()]);
            }
        }
        switch (algorithmConfigurator.getExecutionType()) {
            case SIMPLE: {
                configurator.execType = ExecutionType.SIMPLE;
                break;
            }
            case MULTIPLE: {
                configurator.execType = ExecutionType.MULTIPLE;
            }
        }
        configurator.algorithmName = algorithmConfigurator.getAlgorithmName();
        configurator.algorithmVersion = algorithmConfigurator.getAlgorithmVersionId().toString();
        return configurator;
    }

    private tecgraf.openbus.algorithmservice.v1_0.Parameter makeParameter(Parameter<?> configuratorParam, String paramType) {
        tecgraf.openbus.algorithmservice.v1_0.Parameter param = new tecgraf.openbus.algorithmservice.v1_0.Parameter();
        param.name = configuratorParam.getName();
        param.type = paramType;
        if (EnumerationParameter.class.isInstance(configuratorParam)) {
            param.value = new EnumerationParameterImpl();
            for (EnumerationItem item : ((EnumerationParameter)EnumerationParameter.class.cast(configuratorParam)).getItems()) {
                ((EnumerationParameterImpl)EnumerationParameterImpl.class.cast(param.value)).addItem(new tecgraf.openbus.algorithmservice.v1_0.parameters.EnumerationItem(this.fillNullStringParam(item.getId()), this.fillNullStringParam(item.getLabel()), this.fillNullStringParam(item.getValue()), this.fillNullStringParam(item.getDescription()), true));
            }
        }
        if (EnumerationListParameter.class.isInstance(configuratorParam)) {
            param.value = new EnumerationListParameterImpl();
            for (EnumerationItem item : ((EnumerationListParameter)EnumerationListParameter.class.cast(configuratorParam)).getItems()) {
                ((EnumerationListParameterImpl)EnumerationListParameterImpl.class.cast(param.value)).addItem(new tecgraf.openbus.algorithmservice.v1_0.parameters.EnumerationItem(this.fillNullStringParam(item.getId()), this.fillNullStringParam(item.getLabel()), this.fillNullStringParam(item.getValue()), this.fillNullStringParam(item.getDescription()), true));
            }
        }
        return param;
    }
}

