/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.schedulerservice.heuristic;

import csbase.logic.CommandInfo;
import csbase.logic.SGASet;
import csbase.server.services.schedulerservice.CommandGreedinessComparator;
import csbase.server.services.schedulerservice.SchedulerPolicyInterface;
import csbase.server.services.schedulerservice.classadpolicies.ClassAdResourceController;
import csbase.server.services.schedulerservice.heuristic.Allocation;
import csbase.server.services.schedulerservice.heuristic.AllocationComparatorByPriority;
import csbase.server.services.schedulerservice.heuristic.HeuristicApplyer;
import csbase.server.services.schedulerservice.heuristic.ImpossibleAllocationException;
import csbase.server.services.schedulerservice.heuristic.InvalidSGASetException;
import csbase.server.services.schedulerservice.heuristic.ResourceDemandComparator;
import csbase.server.services.schedulerservice.heuristic.ResourceDisponibilityComparator;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MaxLoadShufflePolicy
implements SchedulerPolicyInterface {
    ClassAdResourceController rController = new ClassAdResourceController();
    AllocationComparatorByPriority allocComp = new AllocationComparatorByPriority();
    CommandGreedinessComparator cmdComp = new CommandGreedinessComparator();

    @Override
    public Map<CommandInfo, SGASet> chooseServer(List<CommandInfo> commands, List<SGASet> servers) {
        HeuristicApplyer heuristic = new HeuristicApplyer(this.cmdComp, this.allocComp, commands, servers, this.rController);
        Allocation allocation = heuristic.getAllocation();
        LinkedList<CommandInfo> frozenCommands = new LinkedList<CommandInfo>();
        int nSGAs = servers.size();
        int nCommands = commands.size();
        for (int i = 0; i < nSGAs && frozenCommands.size() != nCommands; ++i) {
            List<SGASet> sgaStates = allocation.getServersSimulations();
            Collections.sort(sgaStates, new ResourceDisponibilityComparator());
            SGASet sga = sgaStates.get(i);
            List<CommandInfo> cmdsToSteal = this.getCommandsToSteal(sga, frozenCommands, allocation);
            if (cmdsToSteal.isEmpty()) continue;
            Collections.sort(cmdsToSteal, new ResourceDemandComparator());
            for (CommandInfo cmd : cmdsToSteal) {
                try {
                    sga = allocation.setAllocation(cmd, sga);
                }
                catch (ImpossibleAllocationException e) {
                    break;
                }
                catch (InvalidSGASetException e) {
                    e.printStackTrace();
                }
            }
            frozenCommands.addAll(allocation.getCurrentlyAllocatedCommands(sga));
        }
        return allocation.getPartialAllocationMap();
    }

    private List<CommandInfo> getCommandsToSteal(SGASet server, List<CommandInfo> frozenCommands, Allocation alloc) {
        List<CommandInfo> cmdsToSteal = alloc.getPossibleChanges(server);
        for (CommandInfo cmd : frozenCommands) {
            cmdsToSteal.remove(cmd);
        }
        return cmdsToSteal;
    }
}

