/*
 * Decompiled with CFR 0.152.
 */
package csbase.server.services.sgaservice;

import csbase.exception.OperationFailureException;
import csbase.exception.ServiceFailureException;
import csbase.exception.algorithms.AlgorithmNotFoundException;
import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.ExtendedCommandFinalizationInfo;
import csbase.logic.FailureFinalizationType;
import csbase.logic.SGAFile;
import csbase.logic.SGAInfo;
import csbase.logic.SimpleCommandFinalizationInfo;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.CommandLineBuilder;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.CommandScript;
import csbase.logic.algorithms.EnvironmentVariable;
import csbase.logic.algorithms.FlowCommandLineContext;
import csbase.logic.algorithms.MonitoredFile;
import csbase.logic.algorithms.flows.FlowNode;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.logic.algorithms.flows.configurator.Input;
import csbase.logic.algorithms.flows.configurator.Node;
import csbase.logic.algorithms.flows.configurator.Output;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.server.Server;
import csbase.server.ServerException;
import csbase.server.Service;
import csbase.server.services.algorithmservice.AlgorithmService;
import csbase.server.services.commandpersistenceservice.CommandPersistenceService;
import csbase.server.services.eventlogservice.EventLogService;
import csbase.server.services.projectservice.ProjectService;
import csbase.server.services.restservice.RestService;
import csbase.server.services.sgaservice.ProjectNotFoundException;
import csbase.server.services.sgaservice.SGA;
import csbase.server.services.sgaservice.SGAService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import sgaidl.CompletedCommandInfo;
import sgaidl.JobControlAction;
import sgaidl.MissingParameterException;
import sgaidl.Pair;
import sgaidl.ProcessState;
import sgaidl.RunningCommandInfo;
import sgaidl.SGACommand;
import sgaidl.SGADaemonOperations;
import tecgraf.javautils.core.io.FileUtils;

public class Command
implements Serializable {
    public static final String MONITOR_FILE_KEY = "csbase_command_monitor_file";
    public static final String MONITOR_FILE_CHUNK_KEY = "csbase_command_monitor_file_chunk";
    public static final String MONITOR_FILE_CHUNK_SEQ_KEY = "csbase_command_monitor_file_chunk_seq";
    private SGAFile[] commandOutputFiles = null;
    private RunningCommandInfo info = null;
    private CommandInfo cmdInfo;
    private boolean newInfo = false;
    private long lastInfoUpdate = 0L;
    private transient SGAService service = null;
    private String[] projectPath = null;
    private String[] algorithmRootPath = null;
    private String[] projectRootPath = null;
    private long startTimeMillis = 0L;
    private transient SGA sga = null;
    private transient SGACommand remoteReference;
    private String command = null;
    private long nupdates = 0L;
    private long expirationInfoDelay;
    private String[] sandbox = null;
    private Map<String[], Long> sandboxSnapshot = null;
    private SGAInfo node;
    private String hostName;
    private boolean executeAsScript;
    private boolean logCommandLineInfo;

    private void eraseFields() {
        this.setRemoteReference(null);
        this.info = null;
        this.newInfo = false;
    }

    public Object getProjectId() {
        return this.cmdInfo.getProjectId();
    }

    String[] getProjectPath() {
        if (!this.existsProject()) {
            return null;
        }
        ProjectService projectService = ProjectService.getInstance();
        return projectService.getProjectPath(this.getProjectId());
    }

    public synchronized void update() throws ServerException {
        if (this.newInfo || !this.isAlive()) {
            return;
        }
        try {
            RunningCommandInfo gotInfo = this.remoteReference.getRunningCommandInfo();
            if (gotInfo != null) {
                this.setNewInfo(gotInfo);
            }
            ++this.nupdates;
        }
        catch (Exception e) {
            this.setRemoteReference(null);
            throw new ServerException("Falha de update do comando:\n\tId: " + this.getId() + "\n", e);
        }
    }

    private synchronized void setNewInfo(RunningCommandInfo gotInfo) {
        this.info = gotInfo;
        this.newInfo = true;
        this.lastInfoUpdate = System.currentTimeMillis();
        this.writeMonitoredFiles();
    }

    private void writeMonitoredFiles() {
        if (!this.sga.hasDataTransferMechanism()) {
            return;
        }
        HashMap monitoredFiles = new HashMap();
        for (Pair info : this.info.processData[0]) {
            if (!info.key.startsWith(MONITOR_FILE_KEY)) continue;
            String[] splits = info.key.split("\\.");
            if (!monitoredFiles.containsKey(splits[1])) {
                monitoredFiles.put(splits[1], new HashMap());
            }
            ((HashMap)monitoredFiles.get(splits[1])).put(splits[0], info.value);
        }
        for (HashMap file : monitoredFiles.values()) {
            String filename = (String)file.get(MONITOR_FILE_KEY);
            String chunk = (String)file.get(MONITOR_FILE_CHUNK_KEY);
            String chunkSeq = (String)file.get(MONITOR_FILE_CHUNK_SEQ_KEY);
            CommandPersistenceService.getInstance().appendToFile(this.cmdInfo, filename, chunk);
        }
    }

    public long getNUpdates() {
        return this.nupdates;
    }

    private SGAFile[] createCommandOutputs(Collection<FileURLValue> outputFileCollection) {
        if (outputFileCollection == null || outputFileCollection.size() == 0) {
            return null;
        }
        ProjectService projectService = ProjectService.getInstance();
        Object projectId = this.getProjectId();
        int numFiles = outputFileCollection.size();
        SGAFile[] commandFiles = new SGAFile[numFiles];
        Iterator<FileURLValue> outputFileIterator = outputFileCollection.iterator();
        for (int i = 0; i < numFiles; ++i) {
            FileURLValue file = outputFileIterator.next();
            String[] filePath = file.getPathAsArray();
            String fileType = file.getType();
            try {
                if (!projectService.existsFile(projectId, filePath)) {
                    String[] dirPath = new String[filePath.length - 1];
                    for (int j = 0; j < filePath.length - 1; ++j) {
                        dirPath[j] = filePath[j];
                    }
                    String fileName = filePath[filePath.length - 1];
                    projectService.createFile(projectId, dirPath, fileName, fileType);
                }
                projectService.setUnderConstruction(projectId, filePath, true);
                commandFiles[i] = new SGAFile(fileType, filePath);
                continue;
            }
            catch (Exception e) {
                commandFiles[i] = null;
                Server.logSevereMessage("Falha na cria\u00e7\u00e3o do arquivo " + file.getPath(), e);
            }
        }
        return commandFiles;
    }

    private void updateCommandStatus() {
        try {
            CommandPersistenceService persistenceService = CommandPersistenceService.getInstance();
            if (persistenceService == null) {
                return;
            }
            persistenceService.updateCommandStatus(this.getCommandInfo());
        }
        catch (ServiceFailureException e) {
            Server.logSevereMessage("Ocorreu um erro ao atualizar o comando " + this.getId() + " no servi\u00e7o de persist\u00eancia", e);
        }
    }

    private void updateCommandOutputFiles() {
        if (this.commandOutputFiles == null) {
            return;
        }
        ProjectService projectService = ProjectService.getInstance();
        Object projectId = this.getProjectId();
        for (SGAFile sgaFile : this.commandOutputFiles) {
            if (sgaFile == null) continue;
            try {
                projectService.setUnderConstruction(projectId, sgaFile.getFileName(), false);
            }
            catch (Exception e) {
                Server.logSevereMessage("Falha na atualiza\u00e7\u00e3o do estado do arquivo " + sgaFile.getFileNameForSeparator('/'), e);
            }
        }
    }

    public boolean finish(CompletedCommandInfo cmdInfo) {
        String msg = "Comando terminado.\nDados da execu\u00e7\u00e3o de (" + this.getId() + ")\n";
        msg = cmdInfo == null || cmdInfo.elapsedTimeSec == -1 ? msg + "\tTempo decorrido: <N\u00e3o informado>;\n" : msg + "\tTempo decorrido: " + cmdInfo.elapsedTimeSec + " segundo(s);\n";
        msg = cmdInfo == null || cmdInfo.userTimeSec == -1 ? msg + "\tTempo de usu\u00e1rio: <N\u00e3o informado>;\n" : msg + "\tTempo de usu\u00e1rio: " + cmdInfo.userTimeSec + " segundo(s);\n";
        msg = cmdInfo == null || cmdInfo.cpuTimeSec == -1 ? msg + "\tTempo de CPU: <N\u00e3o informado>.\n" : msg + "\tTempo de CPU: " + cmdInfo.cpuTimeSec + " segundo(s);\n";
        Server.logInfoMessage(msg);
        this.setRemoteReference(null);
        this.setStatus(CommandStatus.DOWNLOADING);
        boolean success = this.service.clearExecutionEnvironment(this);
        if (success && this.existsProject()) {
            this.updateCommandOutputFiles();
        }
        CommandFinalizationInfo info = this.readCommandFinalizationInfo();
        this.setFinished(info);
        return success;
    }

    public boolean existsProject() {
        ProjectService projectService = ProjectService.getInstance();
        return projectService.existsProject(this.getProjectId());
    }

    private CommandFinalizationInfo readCommandFinalizationInfo() {
        AlgorithmConfigurator configurator = this.getCommandConfigurator();
        if (configurator != null && configurator.hasExitCode()) {
            if (configurator.getConfiguratorType() == AlgorithmConfigurator.ConfiguratorType.FLOW) {
                return this.readFlowFinalizationInfo((FlowAlgorithmConfigurator)configurator);
            }
            return this.readSimpleFinalizationInfo(configurator);
        }
        return new SimpleCommandFinalizationInfo(CommandFinalizationType.END, false);
    }

    private CommandFinalizationInfo readSimpleFinalizationInfo(AlgorithmConfigurator configurator) {
        Integer exitCode = null;
        CommandFinalizationType type = configurator.hasExitCode() ? ((exitCode = this.readIntegerFromFile(configurator.getExitCodeLogFile())) != null ? (exitCode != 0 ? CommandFinalizationType.EXECUTION_ERROR : CommandFinalizationType.SUCCESS) : CommandFinalizationType.NO_EXIT_CODE) : CommandFinalizationType.END;
        boolean hasWarnings = !this.isFileEmpty(configurator.getWarningsFile());
        return new SimpleCommandFinalizationInfo(type, hasWarnings, exitCode);
    }

    private CommandFinalizationInfo readFlowFinalizationInfo(FlowAlgorithmConfigurator configurator) {
        CommandFinalizationType consolidatedType;
        if (configurator.canBeRunAsSimpleCommand()) {
            FlowNode node = (FlowNode)configurator.getFlow().getNodes().iterator().next();
            return this.readSimpleFinalizationInfo(node.getAlgorithmConfigurator());
        }
        ExtendedCommandFinalizationInfo finalizationInfo = new ExtendedCommandFinalizationInfo(CommandFinalizationType.END, false);
        boolean foundError = false;
        boolean foundAllCodes = true;
        boolean hasAllCodes = true;
        boolean hasWarnings = false;
        for (FlowNode node : configurator.getFlow().getNodes()) {
            AlgorithmConfigurator nodeConfigurator = node.getAlgorithmConfigurator();
            CommandFinalizationInfo nodeInfo = this.readSimpleFinalizationInfo(nodeConfigurator);
            if (!this.isFileEmpty(nodeConfigurator.getWarningsFile())) {
                hasWarnings = true;
            }
            if (node.hasExitCode()) {
                if (nodeInfo.getFinalizationType() == CommandFinalizationType.NO_EXIT_CODE) {
                    foundAllCodes = false;
                } else if (nodeInfo.getFinalizationType() == CommandFinalizationType.EXECUTION_ERROR) {
                    foundError = true;
                }
            } else if (!node.isBypassed()) {
                hasAllCodes = false;
            }
            finalizationInfo.setFinalizationInfoForNode(nodeInfo, node.getId());
        }
        Integer consolidatedExitCode = null;
        if (foundError) {
            Integer guiltyNodeId;
            FileURLValue guiltyNodeLog = configurator.getGuiltyNodeLog();
            if (guiltyNodeLog != null && (guiltyNodeId = this.readIntegerFromFile(guiltyNodeLog)) != null) {
                finalizationInfo.setGuiltyNodeId(guiltyNodeId);
                CommandFinalizationInfo finalizationInfoForNode = finalizationInfo.getFinalizationInfoForNode(guiltyNodeId.intValue());
                if (finalizationInfoForNode != null) {
                    consolidatedExitCode = finalizationInfoForNode.getExitCode();
                }
            }
            consolidatedType = CommandFinalizationType.EXECUTION_ERROR;
        } else if (hasAllCodes) {
            if (foundAllCodes) {
                consolidatedExitCode = 0;
                consolidatedType = CommandFinalizationType.SUCCESS;
            } else {
                consolidatedType = CommandFinalizationType.NO_EXIT_CODE;
            }
        } else {
            consolidatedType = CommandFinalizationType.END;
        }
        finalizationInfo.setExitCode(consolidatedExitCode);
        finalizationInfo.setFinalizationType(consolidatedType);
        finalizationInfo.setHasWarnings(hasWarnings);
        return finalizationInfo;
    }

    /*
     * Exception decompiling
     */
    private boolean isFileEmpty(FileURLValue file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer readIntegerFromFile(FileURLValue file) {
        String[] filePath;
        Object projectId;
        if (file == null || !this.existsProject()) {
            return null;
        }
        ProjectService projectService = ProjectService.getInstance();
        if (!projectService.existsFile(projectId = this.getProjectId(), filePath = file.getPathAsArray())) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = projectService.getInputStream(projectId, filePath);
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(inputStream));
            String line = buffReader.readLine();
            Integer value = null;
            if (line != null) {
                value = Integer.parseInt(line);
            }
            Integer n = value;
            return n;
        }
        catch (IOException e) {
            Server.logSevereMessage("Ocorreu um erro na tentativa de ler o conte\u00fado do arquivo " + FileUtils.joinPath((String[])filePath) + " do projeto " + projectId + " com o c\u00f3digo de sa\u00edda do comando " + this.getId() + ".\n", e);
        }
        catch (NumberFormatException e) {
            Server.logSevereMessage("Formatado inv\u00e1lido no c\u00f3digo de sa\u00edda do comando " + this.getId() + ".\n", e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                Server.logSevereMessage(e.getMessage(), e);
            }
        }
        return null;
    }

    private AlgorithmConfigurator getCommandConfigurator() {
        AlgorithmConfigurator configurator = null;
        try {
            configurator = this.getCommandInfo().getConfigurator();
        }
        catch (RemoteException e) {
            Server.logSevereMessage("Ocorreu um erro na tentativa de obter o configurador do comando " + this.getId() + ".\n", e);
        }
        return configurator;
    }

    public synchronized boolean kill() {
        try {
            this.remoteReference.control(JobControlAction.TERMINATE, "");
            this.setRemoteReference(null);
            this.setStatus(CommandStatus.DOWNLOADING);
            boolean success = this.service.clearExecutionEnvironment(this);
            if (success && this.existsProject()) {
                this.updateCommandOutputFiles();
            }
            this.setFinished((CommandFinalizationInfo)new SimpleCommandFinalizationInfo(CommandFinalizationType.KILLED, false));
            Server.logWarningMessage("Comando interrompido:\n\tId: " + this.getId() + "\n");
            this.eraseFields();
            return true;
        }
        catch (Exception e) {
            this.setRemoteReference(null);
            Server.logSevereMessage("Falha ao cancelar comando " + this.getId() + " do usu\u00e1rio " + Service.getUser().getId() + ": " + e.getMessage(), e);
            return false;
        }
    }

    public synchronized void failed(FailureFinalizationType cause) {
        this.setFinished((CommandFinalizationInfo)new SimpleCommandFinalizationInfo(CommandFinalizationType.FAILED, cause));
        Server.logWarningMessage("Comando com falha:\n\tId: " + this.getId() + "\n");
        this.eraseFields();
    }

    public synchronized void lost() {
        this.setStatus(CommandStatus.DOWNLOADING);
        boolean success = this.service.clearExecutionEnvironment(this);
        if (success && this.existsProject()) {
            this.updateCommandOutputFiles();
        }
        this.setFinished((CommandFinalizationInfo)new SimpleCommandFinalizationInfo(CommandFinalizationType.LOST, false));
        Server.logWarningMessage("Comando perdido:\n\tId: " + this.getId() + "\n");
        this.eraseFields();
    }

    boolean requireMail() {
        return this.cmdInfo.isMailAtEnd();
    }

    public String[] getEmailList() {
        return this.cmdInfo.getEmailList();
    }

    long getStartTime() {
        return this.startTimeMillis;
    }

    String getDescription() {
        return this.cmdInfo.getDescription();
    }

    public String getTip() {
        return this.cmdInfo.getTip();
    }

    public Object getUserId() {
        return this.cmdInfo.getUserId();
    }

    public String getId() {
        return this.cmdInfo.getId();
    }

    public boolean hasWarnings() {
        return this.cmdInfo.hasWarnings();
    }

    protected CommandInfo getCommandInfo() {
        return this.cmdInfo;
    }

    public String getCommand() {
        return this.command;
    }

    public CommandStatus getStatus() {
        return this.cmdInfo.getStatus();
    }

    public CommandFinalizationInfo getFinalizationInfo() {
        return this.cmdInfo.getFinalizationInfo();
    }

    public Map<String, String> getProcessDataMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.info != null) {
            Pair[] data = this.info.processData[0];
            int imax = data.length;
            for (int i = 0; i < imax; ++i) {
                map.put(data[i].key, data[i].value);
            }
        }
        return map;
    }

    private boolean setStatus(CommandStatus cmdStatus) {
        if (this.cmdInfo.setStatus(cmdStatus)) {
            this.updateCommandStatus();
            this.sga.saveCommandTable();
            return true;
        }
        return false;
    }

    private void setFinished(CommandFinalizationInfo info) {
        this.cmdInfo.setFinished(info);
        this.updateCommandStatus();
        this.sga.saveCommandTable();
    }

    public synchronized void setRemoteReference(SGACommand remoteReference) {
        this.remoteReference = remoteReference;
    }

    boolean isAlive() {
        return this.remoteReference != null;
    }

    String[] getSandbox() {
        return this.sandbox;
    }

    SGA getSGA() {
        return this.sga;
    }

    void setSGA(SGA sga) {
        this.sga = sga;
    }

    void setSandboxSnapshot(Map<String[], Long> snapshot) {
        this.sandboxSnapshot = snapshot;
    }

    Map<String[], Long> getSandboxSnapshot() {
        return this.sandboxSnapshot;
    }

    void setSandbox(String[] sandbox) {
        this.sandbox = sandbox;
    }

    void setProjectPath(String[] projectPath) {
        this.projectPath = projectPath;
    }

    void setProjectRootPath(String[] projectRootPath) {
        this.projectRootPath = projectRootPath;
    }

    void setAlgorithmRootPath(String[] algorithmRootPath) {
        this.algorithmRootPath = algorithmRootPath;
    }

    protected synchronized void executeRemoteCommand() {
        String id = this.getId();
        if (this.service.getSGACommand(this.getSGA().getName(), id) == null) {
            return;
        }
        this.setStatus(CommandStatus.UPLOADING);
        if (!this.service.setupExecutionEnvironment(this)) {
            this.sga.failCommand(id, FailureFinalizationType.FAILED_SETUP_EXECUTION_ENVIRONMENT);
            return;
        }
        TreeSet<String> sandboxes = new TreeSet<String>();
        try {
            FlowAlgorithmConfigurator flowConfigurator;
            AlgorithmConfigurator configurator = this.cmdInfo.getConfigurator();
            CommandLineContext context = this.createContextForConfigurator();
            sandboxes.add(FileUtils.joinPath((char)context.getFileSeparator(), (String[])new String[]{context.getSandboxRootDirectory(), context.getSandboxDirectory()}));
            if (this.isFlow(configurator)) {
                flowConfigurator = (FlowAlgorithmConfigurator)configurator;
                FlowCommandLineContext flowContext = this.createFlowContextForConfigurator(context, flowConfigurator);
                context = flowContext;
                sandboxes.add(FileUtils.joinPath((char)flowContext.getFileSeparator(), (String[])new String[]{flowContext.getSandboxRootDirectory(), flowContext.getSandboxDirectory()}));
                Set nodes = flowConfigurator.getNodes();
                for (Node flowNode : nodes) {
                    CommandLineContext nodeContext = this.createContextForConfigurator(flowNode.getId());
                    sandboxes.add(FileUtils.joinPath((char)nodeContext.getFileSeparator(), (String[])new String[]{nodeContext.getSandboxRootDirectory(), nodeContext.getSandboxDirectory()}));
                    Set<String> linkDirs = this.getLinkDirNames(flowNode, flowContext);
                    sandboxes.addAll(linkDirs);
                    flowContext.addFlowNodeContext(Integer.valueOf(flowNode.getId()), nodeContext);
                }
            }
            if (this.existsProject()) {
                Set outputFileCollection = configurator.getOutputFiles();
                CommandScript[] outputDirColletion = configurator.getOutputDirectories();
                TreeSet<FileURLValue> outputs = new TreeSet<FileURLValue>();
                outputs.addAll((Collection<FileURLValue>)outputDirColletion);
                outputs.addAll(outputFileCollection);
                this.commandOutputFiles = this.createCommandOutputs(outputs);
            }
            if (this.executeAsScript) {
                CommandScript[] commandScripts;
                for (CommandScript script : commandScripts = configurator.makeCommandLineAsScript(context)) {
                    this.saveCommandScript(script);
                }
                this.command = commandScripts[0].makeCommandLine();
                this.service.uploadScripts(this);
            } else {
                this.command = configurator.makeCommandLine(context);
            }
            if (this.logCommandLineInfo) {
                if (configurator.getConfiguratorType() == AlgorithmConfigurator.ConfiguratorType.FLOW) {
                    flowConfigurator = (FlowAlgorithmConfigurator)configurator;
                    Set nodes = flowConfigurator.getNodes();
                    if (nodes.size() == 1) {
                        Node node = (Node)nodes.iterator().next();
                        this.logCommandLineInfo(id, node.getConfigurator(), "simple");
                    } else {
                        for (Node flowNode : nodes) {
                            AlgorithmConfigurator nodeConfigurator = flowNode.getConfigurator();
                            this.logCommandLineInfo(id, nodeConfigurator, "flow");
                        }
                    }
                } else {
                    this.logCommandLineInfo(id, configurator, "simple");
                }
            }
            Server.logInfoMessage("Linha de comando: " + this.command);
            String hostNameParam = this.hostName;
            if (hostNameParam == null) {
                hostNameParam = "";
            }
            SGADaemonOperations sgaRemoteReference = this.sga.getSGADaemon();
            Map extraPropMap = this.getCommandInfo().getExtraPropertiesMap();
            LinkedList<Pair> extraParams = new LinkedList<Pair>();
            extraParams.add(new Pair("csbase_command_output_path", this.getOutputDirectoryAsString(context)));
            extraParams.add(new Pair("csbase_command_root_path", this.getProjectDirAsString(context)));
            extraParams.add(new Pair("csbase_command_path", this.getBinaryDirectoryAsString(configurator, context)));
            Optional<User> optUser = Optional.ofNullable(Service.getUser());
            if (optUser.isPresent()) {
                RestService restService = RestService.getInstance();
                String token = restService.createToken(optUser.get().getLogin(), null, null, new Date());
                extraParams.add(new Pair("csbase_command_user_token", token));
                if (!optUser.get().getLogin().equals(User.getAdminId())) {
                    extraParams.add(new Pair("csbase_command_user_id", optUser.get().getLogin()));
                }
            }
            if (this.sga.hasDataTransferMechanism()) {
                List monitoredFiles = this.cmdInfo.getMonitoredFiles();
                for (int i = 1; i <= monitoredFiles.size(); ++i) {
                    extraParams.add(new Pair("csbase_command_monitor_file." + i, ((MonitoredFile)monitoredFiles.get(i - 1)).getFileName()));
                }
            }
            int sbIndex = 1;
            for (String string : sandboxes) {
                extraParams.add(new Pair("csbase_command_sandbox_paths." + sbIndex, string));
                ++sbIndex;
            }
            for (Map.Entry entry : extraPropMap.entrySet()) {
                extraParams.add(new Pair((String)entry.getKey(), (String)entry.getValue()));
            }
            this.remoteReference = sgaRemoteReference.executeCommand(this.command, id, extraParams.toArray(new Pair[extraParams.size()]));
            if (this.remoteReference == null) {
                this.sga.failCommand(id, FailureFinalizationType.SGA_EXECUTION_ERROR);
                String errorMessage = "Erro inesperado na execu\u00e7\u00e3o do comando pelo SGA. O erro est\u00e1 registrado no log do SGA.\n";
                Server.logSevereMessage(errorMessage + "\tCausa: " + errorMessage + "\n\tId: " + id + "\n\n");
            } else {
                this.setStatus(CommandStatus.EXECUTING);
                Server.logInfoMessage(String.format("Comando '%s' posto em execu\u00e7\u00e3o:\n\tId: %s\n\t(%s)\n\tComando: %s\n", this.getTip(), id, this.sga.getName(), this.command));
            }
        }
        catch (MissingParameterException e) {
            this.sga.failCommand(id, FailureFinalizationType.SGA_EXECUTION_ERROR);
            String errorMessage = "Falha na constru\u00e7\u00e3o do comando durante a prepara\u00e7\u00e3o do ambiente de execu\u00e7\u00e3o.\n";
            Server.logSevereMessage(errorMessage + "\tCausa: " + errorMessage + ": [" + this.command + "]\n\tSGA [" + this.sga.getName() + "] - id: " + id + ".\n\tErro: " + (Object)((Object)e) + ".\n", e);
        }
        catch (Exception e) {
            this.sga.failCommand(id, FailureFinalizationType.FAILED_SETUP_EXECUTION_ENVIRONMENT);
            String errorMessage = "Falha na constru\u00e7\u00e3o do comando durante a prepara\u00e7\u00e3o do ambiente de execu\u00e7\u00e3o.\n";
            Server.logSevereMessage(errorMessage + "\tCausa: " + errorMessage + ": [" + this.command + "]\n\tSGA [" + this.sga.getName() + "] - id: " + id + ".\n\tErro: " + e + ".\n", e);
        }
    }

    private void logCommandLineInfo(String id, AlgorithmConfigurator configurator, String queue) {
        EventLogService eventLogger = EventLogService.getInstance();
        String queueBaseName = "commands";
        String[] logQueue = new String[]{queueBaseName, queue};
        String[] logInfo = new String[]{id, configurator.getAlgorithmName(), this.makeParameterValueList(configurator)};
        eventLogger.addServerInformation(logQueue, logInfo);
    }

    private String makeParameterValueList(AlgorithmConfigurator configurator) {
        Map parameterValues = configurator.getParameterValuesByName();
        StringBuilder parameters = new StringBuilder();
        for (Map.Entry parameter : parameterValues.entrySet()) {
            parameters.append((String)parameter.getKey());
            parameters.append("=");
            parameters.append((String)parameter.getValue());
            parameters.append(" ; ");
        }
        return parameters.toString();
    }

    private boolean isFlow(AlgorithmConfigurator configurator) {
        FlowAlgorithmConfigurator flowAlgorithmConfigurator;
        Set nodes;
        boolean isFlow = false;
        if (configurator.getConfiguratorType() == AlgorithmConfigurator.ConfiguratorType.FLOW && (nodes = (flowAlgorithmConfigurator = (FlowAlgorithmConfigurator)configurator).getNodes()).size() > 1) {
            isFlow = true;
        }
        return isFlow;
    }

    private CommandLineContext createContextForConfigurator() {
        return this.createContextForConfigurator(null);
    }

    private Set<String> getLinkDirNames(Node flowNode, FlowCommandLineContext context) {
        TreeSet<String> dirs = new TreeSet<String>();
        for (Output output : flowNode.getOutputs()) {
            Collection inputs = output.getInputs();
            if (!output.isDir() || inputs.isEmpty()) continue;
            String linkDir = CommandLineBuilder.makeLinkDirName((Integer)flowNode.getId(), (String)output.getParameterName());
            String dirPath = FileUtils.joinPath((String)linkDir, (char)context.getFileSeparator(), (String[])new String[]{context.getSandboxRootDirectory(), context.getSandboxDirectory()});
            dirs.add(dirPath);
        }
        return dirs;
    }

    private FlowCommandLineContext createFlowContextForConfigurator(CommandLineContext simpleContext, FlowAlgorithmConfigurator configurator) {
        char fileSeparator = simpleContext.getFileSeparator();
        HashMap allFromPipes = new HashMap();
        HashMap allToPipes = new HashMap();
        HashMap allLinkDirs = new HashMap();
        for (Node flowNode : configurator.getNodes()) {
            for (Output output : flowNode.getOutputs()) {
                for (Input input : output.getInputs()) {
                    HashMap<String, String> fromPipes;
                    if (output.isDir()) {
                        HashMap<String, String> inputDirs;
                        HashMap<String, String> outputDirs = (HashMap<String, String>)allLinkDirs.get(output.getNodeId());
                        if (outputDirs == null) {
                            outputDirs = new HashMap<String, String>();
                            allLinkDirs.put(output.getNodeId(), outputDirs);
                        }
                        if ((inputDirs = (HashMap<String, String>)allLinkDirs.get(input.getNodeId())) == null) {
                            inputDirs = new HashMap<String, String>();
                            allLinkDirs.put(input.getNodeId(), inputDirs);
                        }
                        String linkDir = CommandLineBuilder.makeLinkDirName((Integer)flowNode.getId(), (String)output.getParameterName());
                        String linkDirPath = CommandLineBuilder.makePathWithEnvironmentVariable((EnvironmentVariable)EnvironmentVariable.FLOW_SANDBOX_DIR, (String)linkDir, (char)fileSeparator);
                        outputDirs.put(output.getParameterName(), linkDirPath);
                        inputDirs.put(input.getParameterName(), linkDirPath);
                        continue;
                    }
                    HashMap<String, String> toPipes = (HashMap<String, String>)allToPipes.get(input.getNodeId());
                    if (toPipes == null) {
                        toPipes = new HashMap<String, String>();
                        allToPipes.put(input.getNodeId(), toPipes);
                    }
                    if ((fromPipes = (HashMap<String, String>)allFromPipes.get(flowNode.getId())) == null) {
                        fromPipes = new HashMap<String, String>();
                        allFromPipes.put(flowNode.getId(), fromPipes);
                    }
                    String toPipeName = CommandLineBuilder.makeToPipeName((Integer)input.getNodeId(), (String)input.getParameterName());
                    String fromPipeName = CommandLineBuilder.makeFromPipeName((Integer)flowNode.getId(), (String)output.getParameterName());
                    String toPipePath = CommandLineBuilder.makePathWithEnvironmentVariable((EnvironmentVariable)EnvironmentVariable.FLOW_SANDBOX_DIR, (String)toPipeName, (char)fileSeparator);
                    String fromPipePath = CommandLineBuilder.makePathWithEnvironmentVariable((EnvironmentVariable)EnvironmentVariable.FLOW_SANDBOX_DIR, (String)fromPipeName, (char)fileSeparator);
                    fromPipes.put(output.getParameterName(), fromPipePath);
                    toPipes.put(input.getParameterName(), toPipePath);
                }
            }
        }
        FlowCommandLineContext context = FlowCommandLineContext.createFlowContext((CommandLineContext)simpleContext, allFromPipes, allToPipes, allLinkDirs);
        return context;
    }

    private CommandLineContext createContextForConfigurator(Integer nodeId) {
        String id = this.getId();
        char fileSeparator = this.node.getFileSeparator();
        String projectDirectory = FileUtils.joinPath((char)fileSeparator, (String[])this.getProjectDirectory());
        String sandboxDirectory = FileUtils.joinPath((char)fileSeparator, (String[])this.getSandboxDirectory(nodeId));
        String projRootPath = FileUtils.joinPath((boolean)true, (char)fileSeparator, (String[])this.getProjectRootDirectory());
        String algoRootPath = FileUtils.joinPath((boolean)true, (char)fileSeparator, (String[])this.getAlgorithmRootDirectory());
        String sandboxRootPath = FileUtils.joinPath((boolean)true, (char)fileSeparator, (String[])this.getSandboxRootDirectory());
        String commandPersistencyPath = FileUtils.joinPath((boolean)true, (char)fileSeparator, (String[])this.getCommandPersistencyDirectory());
        CommandLineContext context = new CommandLineContext(id, this.node.getPlatformId(), this.getProjectId(), fileSeparator, projectDirectory, algoRootPath, projRootPath, sandboxRootPath, sandboxDirectory, commandPersistencyPath, this.executeAsScript, nodeId, this.cmdInfo.getClientHostName());
        return context;
    }

    private void saveCommandScript(CommandScript script) throws OperationFailureException {
        CommandPersistenceService persistenceService = CommandPersistenceService.getInstance();
        persistenceService.saveCommandScript(script.getFileName(), this.getId(), this.getProjectId(), script.getScriptContent());
    }

    private String getOutputDirectoryAsString(CommandLineContext context) {
        char separatorChar = context.getFileSeparator();
        String logDir = FileUtils.joinPath((char)separatorChar, (String[])CommandPersistenceService.getInstance().getLogDirectory(this.getId()));
        return FileUtils.joinPath((char)separatorChar, (String[])new String[]{context.getProjectRootDirectory(), context.getProjectDirectory(), logDir});
    }

    private String getProjectDirAsString(CommandLineContext context) {
        char separatorChar = context.getFileSeparator();
        String cmdDir = FileUtils.joinPath((char)separatorChar, (String[])CommandPersistenceService.getInstance().getCommandDirectory(this.getId()));
        return FileUtils.joinPath((char)separatorChar, (String[])new String[]{context.getProjectRootDirectory(), context.getProjectDirectory(), cmdDir});
    }

    private String getBinaryDirectoryAsString(AlgorithmConfigurator configurator, CommandLineContext context) {
        char fileSeparator = context.getFileSeparator();
        Set binaryDirectorySet = configurator.getBinaryDirectories(this.node.getPlatformId(), fileSeparator);
        String binaryPath = !this.isFlow(configurator) ? FileUtils.joinPath((char)fileSeparator, (String[])new String[]{context.getAlgorithmRootDirectory(), (String)binaryDirectorySet.iterator().next()}) : "./";
        return binaryPath;
    }

    private String[] getSandboxDirectory(Integer nodeId) {
        String sandboxDir = FileUtils.fixDirectoryName((String)this.getId());
        if (nodeId != null) {
            return new String[]{sandboxDir, sandboxDir + "_" + nodeId};
        }
        return new String[]{sandboxDir};
    }

    private String[] getCommandPersistencyDirectory() {
        return SGAService.combinePaths(this.getProjectRootDirectory(), this.getProjectDirectory(), this.cmdInfo.getPersistencyPath());
    }

    private String[] getAlgorithmRootDirectory() {
        if (this.algorithmRootPath == null) {
            return this.node.getAlgorithmRootDirectory();
        }
        return this.algorithmRootPath;
    }

    private String[] getProjectRootDirectory() {
        if (this.projectRootPath == null) {
            return this.node.getProjectRootDirectory();
        }
        return this.projectRootPath;
    }

    private String[] getSandboxRootDirectory() {
        return this.node.getSandboxRootDirectory();
    }

    private String[] getProjectDirectory() {
        if (this.projectPath == null) {
            return this.getProjectPath();
        }
        return this.projectPath;
    }

    void setService(SGAService sgaService) {
        this.service = sgaService;
    }

    public Command(String hostName, SGA sga, CommandInfo cmdInfo, long expirationInfoDelay, boolean asScript, boolean logCommandLineInfo) throws ProjectNotFoundException {
        this.cmdInfo = cmdInfo;
        this.sga = sga;
        this.hostName = hostName;
        this.node = hostName == null ? this.sga.getInfo(0) : this.sga.getInfo(hostName);
        this.expirationInfoDelay = expirationInfoDelay;
        this.executeAsScript = asScript;
        this.logCommandLineInfo = logCommandLineInfo;
        Object projectId = cmdInfo.getProjectId();
        if (projectId != null) {
            if (!this.existsProject()) {
                String message = String.format("O projeto %s n\u00e3o foi encontrado.", projectId);
                throw new ProjectNotFoundException(message);
            }
            this.service = SGAService.getInstance();
            try {
                cmdInfo.setMonitoredFiles(this.buildMonitoredFilesList(cmdInfo.getConfigurator()));
            }
            catch (RemoteException e) {
                Server.logWarningMessage("Erro ao montar a lista de arquivos monitorados do comando " + this.getId());
            }
            this.startTimeMillis = Calendar.getInstance().getTimeInMillis();
            this.setStatus(CommandStatus.INIT);
            Server.logInfoMessage("Pedido de comando:\n\tUsu\u00e1rio: " + cmdInfo.getUserId() + "\n\tId: " + cmdInfo.getId());
        }
    }

    public SGAInfo getNode() {
        return this.node;
    }

    public String getProjectName() {
        ProjectService projectService = ProjectService.getInstance();
        return projectService.getProjectName(this.getProjectId());
    }

    public synchronized CommandInfo createCommandInfo() {
        this.newInfo = false;
        if (System.currentTimeMillis() - this.lastInfoUpdate > this.expirationInfoDelay || this.info == null) {
            if (this.cmdInfo.getStatus() == CommandStatus.EXECUTING && !this.isAlive()) {
                this.cmdInfo.invalidateDynamicFields();
            }
            return this.cmdInfo;
        }
        Hashtable[] infos = this.buildProcessInfo(this.info.processData);
        if (infos.length == 0) {
            this.cmdInfo.validateDynamicFields();
            return this.cmdInfo;
        }
        boolean queued = false;
        for (Hashtable processInfo : infos) {
            String state = (String)processInfo.get("csbase_command_state");
            if (!state.equals(ProcessState.WAITING.toString())) continue;
            queued = true;
            break;
        }
        this.cmdInfo.setQueued(queued);
        Double allCPUPerc = 0.0;
        for (Hashtable processInfo : infos) {
            Double singleCPUPerc = Double.parseDouble((String)processInfo.get("csbase_command_cpu_perc"));
            if (singleCPUPerc < 0.0) {
                allCPUPerc = null;
                break;
            }
            allCPUPerc = allCPUPerc + singleCPUPerc;
        }
        this.cmdInfo.setCpuPerc(allCPUPerc);
        Double allRAMMB = 0.0;
        for (Hashtable processInfo : infos) {
            Double singleRAMMB = Double.parseDouble((String)processInfo.get("csbase_command_memory_ram_size_mb"));
            if (singleRAMMB < 0.0) {
                allRAMMB = null;
                break;
            }
            allRAMMB = allRAMMB + singleRAMMB;
        }
        this.cmdInfo.setRAMMemoryMB(allRAMMB);
        Double memoryRAMPerc = null;
        if (allRAMMB != null) {
            int sgaRAMMB = 0;
            for (SGAInfo sgaInfo : this.sga.getAllInfo()) {
                sgaRAMMB += sgaInfo.getRAMMemoryInfoMb();
            }
            memoryRAMPerc = sgaRAMMB == 0 ? null : Double.valueOf(100.0 * (allRAMMB / (double)sgaRAMMB));
        }
        this.cmdInfo.setRAMMemoryPerc(memoryRAMPerc);
        Double allSwapMB = 0.0;
        for (Hashtable processInfo : infos) {
            Double singleSwapMB = Double.parseDouble((String)processInfo.get("csbase_command_memory_swap_size_mb"));
            if (singleSwapMB < 0.0) {
                allSwapMB = null;
                break;
            }
            allSwapMB = allSwapMB + singleSwapMB;
        }
        this.cmdInfo.setSwapMemoryMB(allSwapMB);
        Double memorySwapPerc = null;
        if (allSwapMB != null) {
            int sgaSwapMB = 0;
            for (SGAInfo sgaInfo : this.sga.getAllInfo()) {
                sgaSwapMB += sgaInfo.getSwapMemoryInfoMb();
            }
            memorySwapPerc = sgaSwapMB == 0 ? null : Double.valueOf(100.0 * (allSwapMB / (double)sgaSwapMB));
        }
        this.cmdInfo.setSwapMemoryPerc(memorySwapPerc);
        Integer wallTimeSec = Integer.parseInt((String)infos[0].get("csbase_command_wall_time_sec"));
        if (wallTimeSec < 0) {
            wallTimeSec = null;
        }
        this.cmdInfo.setWallTimeSec(wallTimeSec);
        Double allUserTimeSec = 0.0;
        for (Hashtable processInfo : infos) {
            Double singleUserTimeSec = Double.parseDouble((String)processInfo.get("csbase_command_user_time_sec"));
            if (singleUserTimeSec < 0.0) {
                allUserTimeSec = null;
                break;
            }
            allUserTimeSec = allUserTimeSec + singleUserTimeSec;
        }
        this.cmdInfo.setUserTimeSec(allUserTimeSec);
        Double allSystemTimeSec = 0.0;
        for (Hashtable processInfo : infos) {
            Double singleSystemTimeSecc = Double.parseDouble((String)processInfo.get("csbase_command_system_time_sec"));
            if (singleSystemTimeSecc < 0.0) {
                allSystemTimeSec = null;
                break;
            }
            allSystemTimeSec = allSystemTimeSec + singleSystemTimeSecc;
        }
        this.cmdInfo.setSystemTimeSec(allSystemTimeSec);
        Double allVirtualMemorySizeMB = 0.0;
        for (Hashtable processInfo : infos) {
            Double singleVirtualMemorySizeMB = Double.parseDouble((String)processInfo.get("csbase_command_virtual_memory_size_mb"));
            if (singleVirtualMemorySizeMB < 0.0) {
                allVirtualMemorySizeMB = null;
                break;
            }
            allVirtualMemorySizeMB = allVirtualMemorySizeMB + singleVirtualMemorySizeMB;
        }
        this.cmdInfo.setVirtualMemorySizeMB(allVirtualMemorySizeMB);
        Double bytesInKB = Double.parseDouble((String)infos[0].get("csbase_command_bytes_in_kb"));
        if (bytesInKB < 0.0) {
            bytesInKB = null;
        }
        this.cmdInfo.setBytesInKB(bytesInKB);
        Double bytesOutKB = Double.parseDouble((String)infos[0].get("csbase_command_bytes_out_kb"));
        if (bytesOutKB < 0.0) {
            bytesOutKB = null;
        }
        this.cmdInfo.setBytesOutKB(bytesOutKB);
        Double diskBytesReadKB = Double.parseDouble((String)infos[0].get("csbase_command_disk_bytes_read_kb"));
        if (diskBytesReadKB < 0.0) {
            diskBytesReadKB = null;
        }
        this.cmdInfo.setDiskBytesReadKB(diskBytesReadKB);
        Double diskBytesWriteKB = Double.parseDouble((String)infos[0].get("csbase_command_disk_bytes_write_kb"));
        if (diskBytesWriteKB < 0.0) {
            diskBytesWriteKB = null;
        }
        this.cmdInfo.setDiskBytesWriteKB(diskBytesWriteKB);
        HashSet<String> nodes = new HashSet<String>();
        for (Hashtable info : infos) {
            String execHost = (String)info.get("csbase_command_exec_host");
            if (execHost == null) continue;
            nodes.add(execHost);
        }
        String executionNodeDescription = "";
        if (this.sga.isCluster()) {
            String sep = "";
            for (String node : nodes) {
                executionNodeDescription = executionNodeDescription + sep + node;
                sep = " | ";
            }
        }
        this.cmdInfo.setExecutionNodeDescription(executionNodeDescription);
        HashMap<String, String> specificData = new HashMap<String, String>();
        for (Pair execInfoPair : this.info.executionData) {
            specificData.put(execInfoPair.key, execInfoPair.value);
        }
        this.cmdInfo.setSpecificData(specificData);
        this.cmdInfo.validateDynamicFields();
        return this.cmdInfo;
    }

    private Hashtable[] buildProcessInfo(Pair[][] infos) {
        LinkedList processInfoList = new LinkedList();
        for (int i = 0; i < infos.length; ++i) {
            Hashtable<String, String> infoMap = new Hashtable<String, String>();
            for (Pair info : infos[i]) {
                infoMap.put(info.key, info.value);
            }
            processInfoList.add(infoMap);
        }
        return processInfoList.toArray(new Hashtable[0]);
    }

    private List<MonitoredFile> buildMonitoredFilesList(AlgorithmConfigurator configurator) {
        HashSet<MonitoredFile> monitoredFiles = new HashSet<MonitoredFile>();
        for (FileURLValue file : configurator.getStandardOutputFiles()) {
            MonitoredFile monitoredFile = new MonitoredFile();
            monitoredFile.setFileName(file.getName());
            monitoredFiles.add(monitoredFile);
        }
        try {
            AlgorithmService algorithmService = AlgorithmService.getInstance();
            if (this.isFlow(configurator)) {
                FlowAlgorithmConfigurator fConfig = (FlowAlgorithmConfigurator)configurator;
                for (Node node : fConfig.getNodes()) {
                    AlgorithmConfigurator nodeConfig = node.getConfigurator();
                    monitoredFiles.addAll(algorithmService.getMonitoredFiles(nodeConfig.getAlgorithmName(), nodeConfig.getAlgorithmVersionId()));
                }
            } else {
                monitoredFiles.addAll(algorithmService.getMonitoredFiles(configurator.getAlgorithmName(), configurator.getAlgorithmVersionId()));
            }
        }
        catch (AlgorithmNotFoundException | IllegalArgumentException e) {
            Server.logWarningMessage(MessageFormat.format("Configura\u00e7\u00e3o de arquivos monitorados do algoritmo {0}:{1} n\u00e3o encontrada.", configurator.getAlgorithmName(), configurator.getAlgorithmVersionId()));
        }
        return monitoredFiles.stream().collect(Collectors.toList());
    }

    private static /* synthetic */ boolean lambda$isFileEmpty$0(String s) {
        return s.trim().length() > 0;
    }
}

