package csbase.sga.rest;

import csbase.sga.rest.CSBaseFacade;

import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.validation.ValidationFeature;
import com.fasterxml.jackson.core.JsonParseException;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;

/**
 * Singleton REST server object for the SGA plugin.
 */
public class RestServer {

   private static RestServer instance = null;

   private HttpServer server;

   protected Logger logger;

   private static String baseUri;

   public static String path(String resource, String suffix) {
      if (suffix.startsWith("/")) {
         suffix = suffix.substring(1);
      }
      if (resource.startsWith("/")) {
         resource = resource.substring(1);
      }
      return baseUri + "/" + resource + "/" + suffix;
   }

   /**
    * Private constructor, to ensure only one instance is ever constructed.
    */
   private RestServer(String host, int port) {
      baseUri = "http://" + host + ":" + port;
      this.logger = Logger.getLogger(this.getClass().getName());
   }

   /**
    * Returns the singleton instance of this class.
    */
   public static RestServer getInstance(String host, int port) {
      if (instance == null) {
         instance = new RestServer(host, port);
      }
      return instance;
   }

   @Provider
   static class JsonParseExceptionMapper implements ExceptionMapper<JsonParseException> {

      @Override
      public Response toResponse(final JsonParseException jpe) {
         // Create and return an appropriate response here
         return Response.status(Response.Status.BAD_REQUEST)
                        .entity("Invalid data supplied for request").build();
      }
   }

   public boolean start() {
     // WA to the error while loading resources from packages and validators
     // Set the current thread classloader to the pluging classloder
     ClassLoader cl = this.getClass().getClassLoader();
     Thread.currentThread().setContextClassLoader(cl);

      // create a resource config that scans for JAX-RS resources and providers in given package
      final ResourceConfig rc = new ResourceConfig().packages("csbase.sga.rest.resources")
                                                    .register(JsonParseExceptionMapper.class)
                                                    .register(ValidationFeature.class)
                                                    .register(JacksonFeature.class)
                                                    .setClassLoader(cl);

      // create and start a new instance of grizzly http server
      // exposing the Jersey application at baseUri
      logger.fine("Starting RestServer at " + baseUri + " (rc: " + rc + ")");
      try {
         server = GrizzlyHttpServerFactory.createHttpServer(URI.create(baseUri), rc);
      } catch (Throwable e) {
         StringBuffer sb = new StringBuffer();
         for (StackTraceElement ste : e.getStackTrace()) {
            sb.append(ste.toString());
            sb.append("\n");
         }
         logger.info("*** Error starting web server: " + sb.toString());
      }
      if (server != null) {
         logger.info("RestServer started at " + baseUri);
         return true;
      } else {
         logger.info("RestServer failed to start at " + baseUri);
         return false;
      }
   }

   public boolean stop() {
      if (server == null) {
         return false;
      }
      HttpServer myServer;
      synchronized (this.server) {
         myServer = this.server;
         this.server = null;
      }
      myServer.shutdown();
      return true;
   }
}
