/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.ssh.pbs;

import csbase.sga.executor.JobData;
import csbase.sga.executor.JobInfo;
import csbase.sga.monitor.SGAInfo;
import csbase.sga.ssh.SGADriver;
import csbase.sga.ssh.pbs.PBSJobData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import sgaidl.ProcessState;

public class PBSDriver
implements SGADriver {
    private static final String SUBMIT_JOB = "echo \"{0}\" | qsub";
    private static final String CHECK_JOB = "qstat -x {0}";
    private static final String KILL_JOB = "qdel {0}";
    private static final String CHECK_ALL_NODES_XML = "pbsnodes -x";
    private static final String CHECK_ALL_JOBS_XML = "qstat -x";
    private static Pattern JOB_ID_PATTERN = Pattern.compile("([^\\.]+)\\.(.*)\n");
    private static Pattern NODES_ATTRIBUTES_PATTERN = Pattern.compile("([^,=]+)=([^,]+)");
    private static Pattern JOBID_PATTERN = Pattern.compile("([^.]+).(\\S+)");
    private static Pattern TIME_INFO_PATTERN = Pattern.compile("(\\d+):(\\d+):(\\d+)");
    private static Pattern JOB_IDS_PATTERN = Pattern.compile("([^,]+)");
    private static Pattern BYTE_INFO_PATTERN = Pattern.compile("(\\d+)(\\S+)");
    private Properties properties;

    @Override
    public void init(Properties properties) {
        this.properties = properties;
    }

    @Override
    public String buildSubmitJobCommand(String script, Map<String, String> extraParam) {
        return MessageFormat.format(SUBMIT_JOB, script);
    }

    @Override
    public String buildKillJobCommand(JobData jobData) {
        PBSJobData data = (PBSJobData)jobData;
        return MessageFormat.format(KILL_JOB, data.getJobId());
    }

    @Override
    public String buildCheckJobCommand(JobData jobData) {
        PBSJobData data = (PBSJobData)jobData;
        return MessageFormat.format(CHECK_JOB, data.getJobId());
    }

    @Override
    public String buildCheckAllJobsCommand() {
        return CHECK_ALL_JOBS_XML;
    }

    @Override
    public JobData parseJobSubmissionOutput(String output) {
        Matcher matcher = JOB_ID_PATTERN.matcher(output);
        if (matcher.matches()) {
            return new PBSJobData(matcher.group(1));
        }
        return null;
    }

    @Override
    public Map<JobData, JobInfo> parseCheckJobOutput(String output) {
        return this.parseXMLJobOutput(output);
    }

    private Map<JobData, JobInfo> parseXMLJobOutput(String output) {
        HashMap<JobData, JobInfo> jobsInfo = new HashMap<JobData, JobInfo>();
        if (output.isEmpty()) {
            return jobsInfo;
        }
        byte[] xmlbytes = output.getBytes();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream input = new ByteArrayInputStream(xmlbytes);
            Document doc = builder.parse(input);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("Job");
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                HashMap<String, String> attrsMap = new HashMap<String, String>();
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                Element jobElem = (Element)nNode;
                this.splitJobId(jobElem.getTextContent(), attrsMap);
                this.fillJobProperties(jobElem, attrsMap);
                JobInfo job = this.convertToJobInfo(attrsMap);
                jobsInfo.put(new PBSJobData((String)attrsMap.get("pid")), job);
            }
            return jobsInfo;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void fillJobProperties(Element jobElem, Map<String, String> attrsMap) {
        int resources_usedCounter = 0;
        NodeList atts = jobElem.getElementsByTagName("*");
        for (int i = 0; i < atts.getLength(); ++i) {
            if (atts.item(i).getNodeName().equals("resources_used")) {
                attrsMap.put(atts.item(i).getNodeName() + ++resources_usedCounter, atts.item(i).getTextContent());
                continue;
            }
            attrsMap.put(atts.item(i).getNodeName(), atts.item(i).getTextContent());
        }
    }

    private void splitJobId(String jobId, Map<String, String> attrsMap) {
        Matcher attrsMatcher = JOBID_PATTERN.matcher(jobId);
        attrsMatcher.find();
        attrsMap.put("pid", attrsMatcher.group(1));
    }

    private JobInfo convertToJobInfo(Map<String, String> jobMap) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.jobParam.put("csbase_command_pid", jobMap.get("pid"));
        jobInfo.jobParam.put("csbase_command_state", this.convertJobState(jobMap.get("job_state")).toString());
        String host = jobMap.get("exec_host");
        jobInfo.jobParam.put("csbase_command_exec_host", host == null ? "" : host);
        this.retrieveResourcesUsed(jobInfo, jobMap);
        return jobInfo;
    }

    private ProcessState convertJobState(String state) {
        switch (state) {
            case "C": {
                return ProcessState.FINISHED;
            }
            case "E": {
                return ProcessState.FINISHED;
            }
            case "H": {
                return ProcessState.SLEEPING;
            }
            case "Q": {
                return ProcessState.WAITING;
            }
            case "R": {
                return ProcessState.RUNNING;
            }
            case "T": {
                return ProcessState.RUNNING;
            }
            case "W": {
                return ProcessState.SLEEPING;
            }
            case "S": {
                return ProcessState.FINISHED;
            }
        }
        return ProcessState.WAITING;
    }

    private void retrieveResourcesUsed(JobInfo jobInfo, Map<String, String> jobMap) {
        String ctimeS = jobMap.get("resources_used1");
        String ramS = jobMap.get("resources_used2");
        String swapS = jobMap.get("resources_used3");
        String walltimeS = jobMap.get("resources_used4");
        long ram = ramS != null ? this.getInfoInMb(ramS) : -1L;
        long swap = swapS != null ? this.getInfoInMb(swapS) : -1L;
        long ctime = ctimeS != null ? this.getInfoInSec(ctimeS) : -1L;
        long walltime = walltimeS != null ? this.getInfoInSec(walltimeS) : -1L;
        jobInfo.jobParam.put("csbase_command_memory_ram_size_mb", Long.toString(ram));
        jobInfo.jobParam.put("csbase_command_memory_swap_size_mb", Long.toString(swap));
        jobInfo.jobParam.put("csbase_command_time_sec", Long.toString(ctime));
        jobInfo.jobParam.put("csbase_command_wall_time_sec", Long.toString(walltime));
    }

    @Override
    public String buildCheckEnvironmentCommand() {
        return CHECK_ALL_NODES_XML;
    }

    @Override
    public SGAInfo parseCheckEnvironmentOutput(String output) {
        SGAInfo sga = new SGAInfo(this.properties);
        byte[] xmlbytes = output.getBytes();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream input = new ByteArrayInputStream(xmlbytes);
            Document doc = builder.parse(input);
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName("Node");
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                PBSNodeInfo pbsnode = new PBSNodeInfo();
                if (nNode.getNodeType() == 1) {
                    Element nodeElem = (Element)nNode;
                    NodeList atts = nodeElem.getElementsByTagName("*");
                    for (int i = 0; i < atts.getLength(); ++i) {
                        pbsnode.attMap.put(atts.item(i).getNodeName(), atts.item(i).getTextContent());
                    }
                    if (pbsnode.attMap.get("state").equals("down") || pbsnode.attMap.get("status") == null) continue;
                    this.splitInfo(pbsnode);
                }
                long swapMem = pbsnode.totmemmb - pbsnode.physmemmb;
                long availableRAM = pbsnode.availmemmb >= pbsnode.physmemmb ? pbsnode.availmemmb - pbsnode.physmemmb : 0L;
                long availableSwap = pbsnode.availmemmb - availableRAM;
                sga.addNode(pbsnode.attMap.get("uname"), pbsnode.attMap.get("opsys"), pbsnode.attMap.get("ncpus"), "0", Long.toString(pbsnode.physmemmb), Long.toString(swapMem), Long.toString(availableRAM), Long.toString(availableSwap), pbsnode.attMap.get("loadave"), pbsnode.attMap.get("loadave"), pbsnode.attMap.get("loadave"), Integer.toString(pbsnode.njobs));
            }
            return sga;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void splitInfo(PBSNodeInfo pbsnode) {
        pbsnode.njobs = this.countJobs(pbsnode);
        Matcher attrsMatcher = NODES_ATTRIBUTES_PATTERN.matcher(pbsnode.attMap.get("status"));
        while (attrsMatcher.find()) {
            pbsnode.attMap.put(attrsMatcher.group(1), attrsMatcher.group(2));
        }
        pbsnode.totmemmb = this.getInfoInMb(pbsnode.attMap.get("totmem"));
        pbsnode.availmemmb = this.getInfoInMb(pbsnode.attMap.get("availmem"));
        pbsnode.physmemmb = this.getInfoInMb(pbsnode.attMap.get("physmem"));
    }

    private int countJobs(PBSNodeInfo pbsnode) {
        if (pbsnode.attMap.containsKey("jobs")) {
            Matcher jobsMatcher = JOB_IDS_PATTERN.matcher(pbsnode.attMap.get("jobs"));
            int jobCounter = 0;
            while (jobsMatcher.find()) {
                ++jobCounter;
            }
            return jobCounter;
        }
        return 0;
    }

    private long getInfoInMb(String string) {
        String measure;
        Matcher attrsMatcher = BYTE_INFO_PATTERN.matcher(string);
        attrsMatcher.find();
        long value = Long.parseLong(attrsMatcher.group(1));
        switch (measure = attrsMatcher.group(2)) {
            case "b": {
                value /= 1000000L;
                break;
            }
            case "kb": {
                value /= 1000L;
                break;
            }
            case "mb": {
                break;
            }
            case "gb": {
                value *= 1000L;
                break;
            }
            case "tb": {
                value *= 1000000L;
                break;
            }
            default: {
                value = 0L;
            }
        }
        return value;
    }

    private long getInfoInSec(String string) {
        Matcher attrsMatcher = TIME_INFO_PATTERN.matcher(string);
        attrsMatcher.find();
        return Long.parseLong(attrsMatcher.group(1)) * 3600L + Long.parseLong(attrsMatcher.group(2)) * 60L + Long.parseLong(attrsMatcher.group(3));
    }

    @Override
    public Map<JobData, JobInfo> parseCheckAllJobsOutput(String output) {
        return this.parseXMLJobOutput(output);
    }

    private class PBSNodeInfo {
        public int njobs;
        public long totmemmb;
        public long availmemmb;
        public long physmemmb;
        public Map<String, String> attMap = new HashMap<String, String>();

        private PBSNodeInfo() {
        }
    }
}

