/*
 * Decompiled with CFR 0.152.
 */
package csbase.sga.transfer.ssh;

import csbase.server.plugin.service.IServiceManager;
import csbase.server.plugin.service.algorithmservice.IAlgorithmService;
import csbase.server.plugin.service.projectservice.IProjectService;
import csbase.server.plugin.service.sgaservice.ISGADataTransfer;
import csbase.server.plugin.service.sgaservice.SGADataTransferException;
import csbase.sshclient.SSHClient;
import csbase.sshclient.SSHClientException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.Pattern;

public class SGASSHTransferMechanism
implements ISGADataTransfer {
    private static final String ROOT_KEY = "csbase_csfs_root_dir";
    private static final String HOST_KEY = "ssh_host";
    private static final String PORT_KEY = "ssh_port";
    private static final String PRIVATE_KEY_PATH_KEY = "ssh_private_key_path";
    private static final String USER_NAME_KEY = "ssh_user_name";
    private static final String USER_PASS_KEY = "ssh_user_pass";
    private static final String TUNNEL_ENABLE_KEY = "ssh_tunnel_enable";
    private static final String TUNNEL_HOST_KEY = "ssh_tunnel_host";
    private static final String TUNNEL_PORT_KEY = "ssh_tunnel_port";
    private static final String TUNNEL_PRIVATE_KEY_PATH_KEY = "ssh_tunnel_private_key_path";
    private static final String TUNNEL_USER_NAME_KEY = "ssh_tunnel_user_name";
    private static final String TUNNNEL_LOCAL_PORT_KEY = "ssh_tunnel_local_port";
    private static final String TUNNNEL_LOCAL_PORT_RANGE_KEY = "ssh_tunnel_local_port_range";
    private IServiceManager serviceManager;
    private Properties properties;
    private String root;
    private SSHClient sshClient;
    private String host;
    private int port;
    private String privateKey;
    private String userName;
    private String password;
    private boolean isTunnelEnable = false;
    private String tunnelHost;
    private int tunnelPort;
    private String tunnelPrivateKeyFilePath;
    private String tunnelUserName;
    private int tunnelLocalPort;
    private int tunnelLocalPortRange;

    public SGASSHTransferMechanism(IServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public void close() throws Exception {
        this.sshClient.disconnect();
    }

    public void copyFrom(String[] remotePath, String[] localPath) throws SGADataTransferException {
        try {
            this.connect();
            this.sshClient.download(this.join(localPath), this.joinRemotePath(remotePath));
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Erro while coping flie from remote {0} [{1}:{2}] to local {3}", this.joinRemotePath(remotePath), this.join(localPath), this.host, this.port);
            throw new SGADataTransferException(msg, (Throwable)e);
        }
    }

    public void copyTo(String[] localPath, String[] remotePath) throws SGADataTransferException {
        try {
            this.connect();
            this.sshClient.upload(this.join(localPath), this.joinRemotePath(remotePath));
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Erro while coping from local {0} to remote {1} [{2}:{3}]", this.join(localPath), this.joinRemotePath(remotePath), this.host, this.port);
            throw new SGADataTransferException(msg, (Throwable)e);
        }
    }

    public boolean checkExistence(String[] remotePath) throws SGADataTransferException {
        try {
            this.connect();
            return this.sshClient.stat(this.joinRemotePath(remotePath));
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Erro while checking existence of remote file {0} [{1}:{2}]", this.join(this.root, this.join(remotePath)), this.host, this.port);
            throw new SGADataTransferException(msg, (Throwable)e);
        }
    }

    public void createDirectory(String[] remotePath) throws SGADataTransferException {
        try {
            this.connect();
            this.sshClient.createDirectory(this.joinRemotePath(remotePath));
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Erro while creating remote directory {0} [{1}:{2}]", this.joinRemotePath(remotePath), this.host, this.port);
            throw new SGADataTransferException(msg, (Throwable)e);
        }
    }

    public void remove(String[] remotePath) throws SGADataTransferException {
        try {
            this.connect();
            this.sshClient.remove(this.joinRemotePath(remotePath));
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Erro while removing remote directory/file {0} [{1}:{2}]", this.joinRemotePath(remotePath), this.host, this.port);
            throw new SGADataTransferException(msg, (Throwable)e);
        }
    }

    public String[] getAlgorithmsRootPath() throws SGADataTransferException {
        IAlgorithmService algorithmService = (IAlgorithmService)this.serviceManager.getService("AlgorithmService");
        return new String[]{algorithmService.getAlgorithmRepositoryPath()};
    }

    public String[] getProjectsRootPath() throws SGADataTransferException {
        IProjectService projectService = (IProjectService)this.serviceManager.getService("ProjectService");
        return new String[]{projectService.getProjectRepositoryPath()};
    }

    public Map<String[], Long> getLocalTimestamps(String[] localPath) throws SGADataTransferException {
        final HashMap<String[], Long> timestampsMap = new HashMap<String[], Long>();
        Path sandbox = Paths.get(this.join(localPath), new String[0]);
        try {
            Files.walkFileTree(sandbox, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    File file = path.toFile();
                    if (!file.isDirectory()) {
                        timestampsMap.put(SGASSHTransferMechanism.splitPath(file.getAbsolutePath()), file.lastModified());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            String msg = MessageFormat.format("Erro while retriving local timestamp {0} [{1}:{2}]", this.join(localPath), this.host, this.port);
            throw new SGADataTransferException(msg, (Throwable)e);
        }
        return timestampsMap;
    }

    public Map<String[], Long> getRemoteTimestamps(String[] remotePath) throws SGADataTransferException {
        HashMap<String[], Long> timestampsMap = new HashMap<String[], Long>();
        try {
            this.connect();
            Map fileMap = this.sshClient.listFiles(this.joinRemotePath(remotePath));
            for (String filePath : fileMap.keySet()) {
                Path relPath = Paths.get(this.root, new String[0]).relativize(Paths.get(filePath, new String[0]));
                timestampsMap.put(SGASSHTransferMechanism.splitPath(relPath.toString()), (Long)fileMap.get(filePath));
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format("Erro while retriving remote timestamp {0} [{1}:{2}]", this.joinRemotePath(remotePath), this.host, this.port);
            throw new SGADataTransferException(msg, (Throwable)e);
        }
        return timestampsMap;
    }

    public void setSGAProperties(Properties properties) {
        this.properties = (Properties)properties.clone();
        this.root = this.properties.getProperty(ROOT_KEY);
        this.host = this.properties.getProperty(HOST_KEY);
        this.port = Integer.parseInt(this.properties.getProperty(PORT_KEY));
        this.userName = this.properties.getProperty(USER_NAME_KEY);
        this.privateKey = this.properties.getProperty(PRIVATE_KEY_PATH_KEY);
        this.password = this.properties.getProperty(USER_PASS_KEY);
        String value = this.properties.getProperty(TUNNEL_ENABLE_KEY);
        if (value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false"))) {
            this.isTunnelEnable = Boolean.valueOf(value);
        }
        if (this.isTunnelEnable) {
            this.tunnelLocalPort = Integer.parseInt(this.properties.getProperty(TUNNNEL_LOCAL_PORT_KEY));
            this.tunnelLocalPortRange = Integer.parseInt(this.properties.getProperty(TUNNNEL_LOCAL_PORT_RANGE_KEY));
            this.tunnelHost = this.properties.getProperty(TUNNEL_HOST_KEY);
            this.tunnelPort = Integer.parseInt(this.properties.getProperty(TUNNEL_PORT_KEY));
            this.tunnelUserName = this.properties.getProperty(TUNNEL_USER_NAME_KEY);
            this.tunnelPrivateKeyFilePath = this.properties.getProperty(TUNNEL_PRIVATE_KEY_PATH_KEY);
        }
    }

    private void connect() throws SSHClientException {
        if (this.sshClient == null) {
            this.sshClient = new SSHClient(this.host, this.port);
            if (this.isTunnelEnable) {
                this.sshClient.createTunnel(this.tunnelHost, this.tunnelPort, this.tunnelUserName, this.tunnelPrivateKeyFilePath, this.tunnelLocalPort, this.tunnelLocalPortRange);
            }
            if (this.privateKey != null) {
                this.sshClient.connect(this.userName, this.privateKey);
            } else if (this.password != null) {
                this.sshClient.connectByPassword(this.userName, this.password);
            }
        }
    }

    private String join(String ... str) {
        String retval = "";
        for (String s : str) {
            retval = retval + File.separator + s;
        }
        return retval.replaceFirst(File.separator, "");
    }

    private String joinRemotePath(String ... remotePath) {
        return this.join(this.root, this.join(remotePath));
    }

    private static String[] splitPath(String path) {
        Scanner scanner = new Scanner(path);
        scanner.useDelimiter(Pattern.quote(File.separator));
        ArrayList<String> pathAsList = new ArrayList<String>();
        while (scanner.hasNext()) {
            String dir = scanner.next();
            if (dir.isEmpty()) continue;
            pathAsList.add(dir);
        }
        scanner.close();
        return pathAsList.toArray(new String[pathAsList.size()]);
    }
}

