/*
 * Decompiled with CFR 0.152.
 */
package csbase.tools;

import Acme.JPM.Encoders.GifEncoder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class BuildVariants {
    private static Variant[] variants = new Variant[]{new Variant("_cut", 255, 255, 255, 40), new Variant("_uc", 205, 205, 205, 245)};
    private static float A = 0.6272f;
    private static float B = -0.3403f;
    private static float C = 0.1132f;
    private static float D = 0.6f;

    public static void main(String[] args) {
        if (args.length == 0) {
            String path;
            while ((path = BuildVariants.chooseFile()) != null) {
                BuildVariants.buildVariants(path);
            }
        } else {
            int i = 0;
            while (i < args.length) {
                BuildVariants.buildVariants(args[i]);
                ++i;
            }
        }
        System.exit(0);
    }

    private static String chooseFile() {
        JFileChooser dialog = new JFileChooser(".");
        dialog.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName().toLowerCase();
                return name.endsWith(".gif") || name.endsWith(".jpg") || name.endsWith(".jpeg") || name.endsWith(".png") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Image files";
            }
        });
        int resp = dialog.showOpenDialog(null);
        if (resp == 0) {
            return dialog.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    private static void buildVariants(String path) {
        ImageData imageData = BuildVariants.loadImage(path);
        int i = 0;
        while (i < variants.length) {
            System.out.println("Gerando " + BuildVariants.variants[i].suffix + "...");
            BuildVariants.buildVariant(imageData, variants[i]);
            ++i;
        }
    }

    private static ImageData loadImage(String path) {
        System.out.print("Carregando " + path);
        ImageData imageData = new ImageData();
        Observer observer = new Observer(imageData);
        imageData.path = path;
        imageData.img = Toolkit.getDefaultToolkit().getImage(path);
        imageData.width = imageData.img.getWidth(observer);
        imageData.height = imageData.img.getHeight(observer);
        while (!observer.isReady()) {
            try {
                Thread.sleep(1000L);
                System.out.print(".");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println();
        return imageData;
    }

    private static void buildVariant(ImageData imageData, Variant variant) {
        Image image = BuildVariants.applyFilter(imageData, variant);
        String newPath = BuildVariants.getVariantPath(imageData, variant);
        try {
            FileOutputStream fos = new FileOutputStream(newPath);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            GifEncoder encoder = new GifEncoder(image, (OutputStream)bos);
            encoder.encode();
            bos.flush();
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Image applyFilter(ImageData imageData, Variant v) {
        BufferedImage img = BuildVariants.getBufferedImage(imageData, 2);
        BufferedImage gry = BuildVariants.getBufferedImage(imageData, 10);
        int y = 0;
        while (y < imageData.height) {
            int x = 0;
            while (x < imageData.width) {
                int argb = img.getRGB(x, y);
                float a = (float)((argb & 0xFF000000) >>> 24) / 255.0f;
                if (a != 0.0f) {
                    float f = (float)(gry.getRGB(x, y) & 0xFF) / 255.0f;
                    f = A * f * f * f + B * f * f + C * f + D;
                    argb = BuildVariants.op(1.0f, a) << 24 | BuildVariants.op(f, v.r) << 16 | BuildVariants.op(f, v.g) << 8 | BuildVariants.op(f, v.b);
                    img.setRGB(x, y, argb);
                }
                ++x;
            }
            ++y;
        }
        return img;
    }

    private static int op(float f, float c) {
        return (int)(Math.min(1.0f, f * c) * 255.0f);
    }

    private static String getVariantPath(ImageData imageData, Variant variant) {
        int p = imageData.path.lastIndexOf(46);
        if (p == -1) {
            return String.valueOf(imageData.path) + variant.suffix;
        }
        return String.valueOf(imageData.path.substring(0, p)) + variant.suffix + imageData.path.substring(p);
    }

    private static BufferedImage getBufferedImage(ImageData imageData, int type) {
        BufferedImage img = new BufferedImage(imageData.width, imageData.height, type);
        Graphics2D g2d = img.createGraphics();
        g2d.drawImage(imageData.img, 0, 0, null);
        return img;
    }

    private static class ImageData {
        String path;
        Image img;
        int width;
        int height;

        private ImageData() {
        }
    }

    private static class Observer
    implements ImageObserver {
        private ImageData imageData;
        private boolean ready;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean imageUpdate(Image i, int f, int x, int y, int w, int h) {
            if ((f & 1) == 1) {
                this.imageData.width = w;
            }
            if ((f & 2) == 2) {
                this.imageData.height = h;
            }
            if ((f & 0x20) == 32) {
                Observer observer = this;
                synchronized (observer) {
                    this.ready = true;
                }
                return false;
            }
            return true;
        }

        synchronized boolean isReady() {
            return this.ready;
        }

        Observer(ImageData imageData) {
            this.imageData = imageData;
            this.ready = false;
        }
    }

    private static class Variant {
        String suffix;
        float r;
        float g;
        float b;
        float a;

        Variant(String suffix, int r, int g, int b, int a) {
            this.suffix = suffix;
            this.r = (float)r / 255.0f;
            this.g = (float)g / 255.0f;
            this.b = (float)b / 255.0f;
            this.a = (float)a / 255.0f;
        }
    }
}

