/*
 * Decompiled with CFR 0.152.
 */
package csbase.tools;

import java.io.File;

public class FileConfigConverter {
    private static boolean TEST_MODE = false;
    private static boolean VERBOSE_MODE = true;

    private static void verbose(String msg) {
        if (VERBOSE_MODE) {
            System.out.println(msg);
        }
    }

    public static void main(String[] args) {
        String dirPath = null;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.equals("-t")) {
                TEST_MODE = true;
            } else if (arg.equals("-v")) {
                VERBOSE_MODE = true;
            } else {
                dirPath = arg;
            }
            ++n2;
        }
        if (dirPath == null) {
            System.out.println("N\u00e3o foi especificado um diret\u00f3rio!\n\n");
            System.out.println("Uso: java csbase.server.services.projectservice.TmpConverter [-t] [-v] <diret\u00f3rio>");
            System.out.println("   -t -> modo de testes (n\u00e3o faz \"renames\") ");
            System.out.println("   -v -> modo verbose");
            return;
        }
        FileConfigConverter.substitutePath(dirPath);
    }

    private static void substitutePath(String dirPath) {
        System.out.println("# Analisando diret\u00f3rio [" + dirPath + "]...");
        File file = new File(dirPath);
        if (!file.exists()) {
            System.out.println("   [ERRO] Diret\u00f3rio [" + file + "] n\u00e3o existe");
            return;
        }
        if (!file.isDirectory()) {
            System.out.println("   [ERRO] [" + file + "] n\u00e3o \u00e9 diret\u00f3rio");
            return;
        }
        FileConfigConverter.substituteFile(file);
    }

    private static void substituteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] children;
            File[] fileArray = children = file.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                FileConfigConverter.substituteFile(f);
                ++n2;
            }
        } else {
            String fileName = file.getName();
            if (FileConfigConverter.looksNewFormat(fileName)) {
                String path = file.getAbsolutePath();
                String msg = "   [N\u00c3O MEXI] Arquivo j\u00e1 aparenta novo formato: " + path;
                FileConfigConverter.verbose(msg);
            } else if (FileConfigConverter.looksOldFormat(fileName)) {
                String pth2;
                String pth1;
                String newFileName = "." + fileName;
                File newFile = new File(file.getParent(), newFileName);
                if (newFile.exists()) {
                    String path = newFile.getAbsolutePath();
                    String msg = "   [SOBREESCREVI] Arquivo j\u00e1 existente: " + path;
                    FileConfigConverter.verbose(msg);
                }
                if (!TEST_MODE) {
                    file.renameTo(newFile);
                    pth1 = file.getAbsolutePath();
                    pth2 = newFile.getAbsolutePath();
                    String msg = " **[MV] ==> " + pth1 + " -> " + pth2;
                    FileConfigConverter.verbose(msg);
                } else {
                    pth1 = file.getAbsolutePath();
                    pth2 = newFile.getAbsolutePath();
                    String msg = "   [SIMULA\u00c7\u00c3O-MV] " + pth1 + " ==> " + pth2;
                    FileConfigConverter.verbose(msg);
                }
            }
        }
    }

    private static boolean looksOldFormat(String fileName) {
        boolean cs = fileName.endsWith(".csbase");
        boolean csb = fileName.endsWith(".csbase_description");
        boolean pt = fileName.startsWith(".");
        return !pt && (cs || csb);
    }

    private static boolean looksNewFormat(String fileName) {
        boolean cs = fileName.endsWith(".csbase");
        boolean csb = fileName.endsWith(".csbase_description");
        boolean pt = fileName.startsWith(".");
        return pt && (cs || csb);
    }
}

