/*
 * Decompiled with CFR 0.152.
 */
package csbase.tools;

import csbase.logic.CommonProjectInfo;
import csbase.logic.ProjectAttribute;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;

public class IncorrectLockingAreaSizeIdentifier {
    public static void main(String[] args) {
        String secArg;
        String err;
        String firstArg;
        String err2;
        if (args.length < 1) {
            err2 = "Arquivo de configura\u00e7\u00e3o n\u00e3o definido!";
            System.out.println("Arquivo de configura\u00e7\u00e3o n\u00e3o definido!\n\n");
            IncorrectLockingAreaSizeIdentifier.printHelp();
            System.exit(-1);
        }
        if (args.length > 2) {
            err2 = "N\u00famero inv\u00e1lido de argumentos.";
            System.out.println("N\u00famero inv\u00e1lido de argumentos.");
            System.out.println("N\u00famero inv\u00e1lido de argumentos.\n\n");
            IncorrectLockingAreaSizeIdentifier.printHelp();
            System.exit(-2);
        }
        if ((firstArg = args[0]) == null || firstArg.trim().isEmpty()) {
            String err3 = "Arquivo de configura\u00e7\u00e3o nulo ou vazio!";
            System.out.println("Arquivo de configura\u00e7\u00e3o nulo ou vazio!");
            System.exit(-3);
            return;
        }
        if (firstArg.trim().equalsIgnoreCase("--help")) {
            IncorrectLockingAreaSizeIdentifier.printHelp();
            return;
        }
        File file = new File(firstArg);
        String absPath = file.getAbsolutePath();
        if (!file.exists()) {
            err = "Arquivo de configura\u00e7\u00e3o n\u00e3o existe: " + absPath;
            System.out.println(err);
            System.exit(-4);
        }
        if (file.isDirectory()) {
            err = "Arquivo de configura\u00e7\u00e3o \u00e9 diret\u00f3rio: " + absPath;
            System.out.println(err);
            System.exit(-5);
        }
        if (!file.canRead()) {
            err = "Arquivo de configura\u00e7\u00e3o sem permiss\u00e3o (R): " + absPath;
            System.out.println(err);
            System.exit(-6);
        }
        if (file.length() <= 0L) {
            err = "Detectado arquivo de configura\u00e7\u00e3o zerado: " + absPath;
            System.out.println(err);
            System.exit(-7);
        }
        boolean forceCorrection = false;
        if (args.length == 2 && (secArg = args[1]).trim().equalsIgnoreCase("--fix")) {
            forceCorrection = true;
        }
        try {
            IncorrectLockingAreaSizeIdentifier.processProjectInfo(file, forceCorrection);
        }
        catch (StreamCorruptedException e) {
            String err4 = "Arquivo n\u00e3o \u00e9 stream de objeto: " + absPath;
            System.out.println(err4);
            System.exit(-7);
        }
        catch (IOException e) {
            String err5 = "Falha de E/S: " + e.getMessage();
            System.out.println(err5);
            System.exit(-8);
        }
        catch (ClassNotFoundException e) {
            String msg = e.getMessage();
            String err6 = "Classe de info n\u00e3o encontrada: " + msg;
            System.out.println(err6);
            System.exit(-9);
        }
        catch (ClassCastException e) {
            String msg = e.getMessage();
            String err7 = "Arquivo n\u00e3o \u00e9 informativo de projeto: " + absPath;
            System.out.println(String.valueOf(err7) + " - " + msg);
            System.exit(-10);
        }
        catch (Throwable t) {
            String msg = t.getMessage();
            String err8 = "Erro interno: " + msg;
            System.out.println(err8);
            t.printStackTrace();
            System.exit(-11);
        }
    }

    private static void printHelp() {
        System.out.println("\n\nIdentifica\u00e7\u00e3o de projetos com inteiros no lugar de longs no atributo de reserva de \u00e1rea de projetos.\n");
        System.out.println("Op\u00e7\u00f5es:");
        System.out.println("--fix\tCorrije projeto com problema.");
        System.out.println("--help\tExibe ajuda.");
    }

    private static void processProjectInfo(File cfgFile, boolean forceCorrection) throws IOException, ClassNotFoundException {
        FileInputStream inFileStream = new FileInputStream(cfgFile);
        BufferedInputStream inBuffStream = new BufferedInputStream(inFileStream);
        DataInputStream inDataStream = new DataInputStream(inBuffStream);
        ObjectInputStream in = new ObjectInputStream(inDataStream);
        Object object = in.readObject();
        in.close();
        CommonProjectInfo info = (CommonProjectInfo)CommonProjectInfo.class.cast(object);
        ProjectAttribute prjAttr = ProjectAttribute.LOCKING_AREA_SIZE;
        String prjAttrKey = prjAttr.getAttributeKey();
        Object att = info.getAttribute(prjAttrKey);
        if (att instanceof Integer) {
            System.err.println("O projeto " + info.name + " do usu\u00e1rio " + info.userId + " tem um Integer no lugar " + "de um Long no atributo LOCKING_AREA_SIZE!!!");
            if (forceCorrection) {
                Integer lockingAreaSizeInt = (Integer)att;
                Long lockingAreaSizeLong = lockingAreaSizeInt.longValue();
                info.setAttribute(prjAttrKey, (Object)lockingAreaSizeLong);
                FileOutputStream outFileStream = new FileOutputStream(cfgFile);
                BufferedOutputStream outBuffStream = new BufferedOutputStream(outFileStream);
                DataOutputStream outDataStream = new DataOutputStream(outBuffStream);
                ObjectOutputStream out = new ObjectOutputStream(outDataStream);
                out.writeObject(info);
                System.out.println("Arquivo " + cfgFile.getAbsolutePath() + " corrigido.");
                out.close();
            }
        }
    }
}

