/*
 * Decompiled with CFR 0.152.
 */
package csbase.tools;

import csbase.tools.PropEditor;
import csbase.tools.PropModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class PropTab {
    private final PropEditor propEditor;
    private JPanel panel = new JPanel();
    private final File file;
    private final JTable table = new JTable();
    private final Properties properties = new Properties();

    public JPanel getPanel() {
        return this.panel;
    }

    public String getDescription(int index) {
        String key = this.getKey(index);
        String name = this.getName();
        String prefix = name.replaceAll("\\.properties$", "");
        String newKey = String.valueOf(prefix) + "@" + key + "@description";
        String desc = (String)this.properties.get(newKey);
        if (desc != null) {
            return desc;
        }
        return this.propEditor.getEditorValue(newKey);
    }

    public String getValue(int index) {
        Enumeration<Object> elements = this.properties.elements();
        int i = 0;
        while (i < index) {
            elements.nextElement();
            ++i;
        }
        return (String)elements.nextElement();
    }

    public String getKey(int index) {
        Enumeration<Object> keys = this.properties.keys();
        int i = 0;
        while (i < index) {
            keys.nextElement();
            ++i;
        }
        return (String)keys.nextElement();
    }

    public int getCardinality() {
        return this.properties.size();
    }

    public String getName() {
        return this.file.getName();
    }

    public PropTab(PropEditor propEditor, File file) throws Exception {
        this.file = file;
        this.propEditor = propEditor;
        this.properties.load(new FileInputStream(file));
        PropEditor.onSpecialSyntax(this.properties, true, false);
        this.table.setModel(new PropModel(this));
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)new JPanel(), "East");
        this.panel.add((Component)new JPanel(), "West");
        this.panel.add((Component)new JPanel(), "South");
        this.panel.add((Component)new JPanel(), "North");
        this.panel.add((Component)scrollPane, "Center");
    }
}

