/*
 * Decompiled with CFR 0.152.
 */
package csbase.tools;

import java.io.IOException;
import java.util.Properties;
import tecgraf.javautils.core.properties.PropertiesUtils;
import tecgraf.javautils.core.properties.PropertyException;

public class PropertiesDumper {
    private PropertiesDumper(String[] args) throws PropertyException {
        try {
            Properties props = PropertiesUtils.loadProperties((String)args[0]);
            if (args.length == 1) {
                props.list(System.out);
            } else if (args.length == 2) {
                System.out.println(props.getProperty(args[1]));
            } else {
                int i = 1;
                while (i < args.length) {
                    System.out.println(String.format("%s=%s", args[i], props.getProperty(args[i])));
                    ++i;
                }
            }
        }
        catch (IOException e) {
            PropertiesDumper.abort(String.valueOf(args[0]) + " n\u00e3o existe", 1);
        }
    }

    private static void abort(String msg, int code) {
        System.err.println(msg);
        System.exit(code);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            PropertiesDumper.abort("uso: PropertiesCollector arq [prop1 prop2...]", 1);
        }
        try {
            new PropertiesDumper(args);
        }
        catch (PropertyException e) {
            PropertiesDumper.abort(e.getMessage(), 1);
        }
    }
}

