/*
 * Decompiled with CFR 0.152.
 */
package csbase.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public abstract class Generator {
    private final StringBuffer buffer = new StringBuffer();
    protected String interfaceName;
    protected String serviceClassName;
    protected String genClassName;

    protected static String getPackageName(String className) {
        int i = className.lastIndexOf(".");
        if (i != -1) {
            return className.substring(0, i);
        }
        return null;
    }

    protected static String getNoPackagesClassName(String className) {
        int i = className.lastIndexOf(".");
        if (i != -1) {
            return className.substring(i + 1);
        }
        return null;
    }

    protected static void usage() {
        System.out.println("uso:");
        System.out.println("args[0]: nome da interface remota do servi\u00e7o");
        System.out.println(" ex.: websintesi.remote.OpenSpiritServiceInterface");
        System.out.println("\nargs[1]: nome da classe que implementa o servi\u00e7o");
        System.out.println(" ex: websintesi.ssi.ospservice.OpenSpiritService");
    }

    protected Generator(String interfaceName, String serviceClassName, String suffix) {
        this.interfaceName = interfaceName;
        this.serviceClassName = serviceClassName;
        this.genClassName = serviceClassName + suffix;
    }

    protected StringBuffer getBuffer() {
        return this.buffer;
    }

    protected final void generate() throws ClassNotFoundException {
        String noPackagesClassName = Generator.getNoPackagesClassName(this.genClassName);
        Class<?> interfaceClass = Class.forName(this.interfaceName);
        this.buffer.append("/*\n");
        this.buffer.append(" * $");
        this.buffer.append("Id:");
        this.buffer.append("$\n");
        this.buffer.append(" */\n\n");
        this.buffer.append("package ");
        this.buffer.append(Generator.getPackageName(this.serviceClassName));
        this.buffer.append(";\n\n");
        this.buffer.append("import ");
        this.buffer.append(this.interfaceName);
        this.buffer.append(";\n\n");
        String[] imports = this.getImports();
        for (int i = 0; imports != null && i < imports.length; ++i) {
            this.buffer.append("import ");
            this.buffer.append(imports[i]);
            this.buffer.append(";\n");
        }
        this.buffer.append("\n\n");
        this.buffer.append("/**\n");
        this.buffer.append(" * Classe de proxy gerada automaticamente para:\n");
        this.buffer.append(" * interface do servi\u00e7o: " + this.interfaceName + "\n");
        this.buffer.append(" * @author Tecgraf/PUC-Rio\n");
        this.buffer.append(" */\n");
        this.buffer.append("public class ");
        this.buffer.append(noPackagesClassName);
        this.buffer.append(" extends ");
        this.buffer.append(this.getSuperClassName());
        this.buffer.append(" implements ");
        this.buffer.append(Generator.getNoPackagesClassName(this.interfaceName));
        this.buffer.append(" {\n\n");
        if (this.invokesSuperClassConstructor()) {
            this.redefineSuperClassConstructors(noPackagesClassName);
        } else {
            String[] excpts = this.getConstructorExceptions();
            this.buffer.append("/**\n");
            this.buffer.append(" * Construtor\n");
            if (excpts != null && excpts.length > 0) {
                for (int e = 0; e < excpts.length; ++e) {
                    this.buffer.append(" * @throws ");
                    this.buffer.append(excpts[e].toString());
                }
                this.buffer.append(" no caso de erro.\n");
            }
            this.buffer.append(" */\n");
            this.buffer.append("public ");
            this.buffer.append(noPackagesClassName);
            this.buffer.append("() ");
            String[] constructorExceptions = this.getConstructorExceptions();
            if (constructorExceptions != null && constructorExceptions.length > 0) {
                this.buffer.append("throws ");
                for (int j = 0; j < constructorExceptions.length; ++j) {
                    if (j > 0) {
                        this.buffer.append(", ");
                    }
                    this.buffer.append(constructorExceptions[j]);
                }
            }
            this.buffer.append(" {}\n");
        }
        Method[] methods = interfaceClass.getMethods();
        this.generateMethods(methods);
        this.buffer.append("}");
    }

    private void generateMethods(Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            Type[] throwses;
            this.buffer.append("\n/** ");
            this.buffer.append("\n * {@inheritDoc} ");
            this.buffer.append("\n */ ");
            this.buffer.append("\n@Override");
            this.buffer.append("\npublic ");
            Type grt = methods[i].getGenericReturnType();
            if (grt instanceof Class) {
                this.buffer.append(this.typeToString((Class)grt));
            } else {
                this.buffer.append(grt.toString());
            }
            this.buffer.append(' ');
            this.buffer.append(methods[i].getName());
            this.buffer.append("(");
            Type[] parameters = methods[i].getGenericParameterTypes();
            String[] paremeterNames = new String[parameters.length];
            if (parameters != null && parameters.length > 0) {
                for (int j = 0; j < parameters.length; ++j) {
                    if (parameters[j] instanceof Class) {
                        this.buffer.append(this.typeToString((Class)parameters[j]));
                    } else {
                        this.buffer.append(parameters[j].toString());
                    }
                    paremeterNames[j] = "param_" + j;
                    this.buffer.append(" " + paremeterNames[j]);
                    if (j >= parameters.length - 1) break;
                    this.buffer.append(", ");
                }
            }
            this.buffer.append(") ");
            if (this.throwsInterfaceExceptions() && (throwses = methods[i].getGenericExceptionTypes()) != null && throwses.length > 0) {
                this.buffer.append("throws ");
                for (int j = 0; j < throwses.length; ++j) {
                    if (throwses[j] instanceof Class) {
                        this.buffer.append(((Class)throwses[j]).getName());
                    } else {
                        this.buffer.append(throwses[j].toString());
                    }
                    if (j >= throwses.length - 1) break;
                    this.buffer.append(", ");
                }
            }
            this.buffer.append(" {\n");
            this.getMethodLines(this.buffer, methods[i], paremeterNames);
            this.buffer.append("}\n");
        }
    }

    private void redefineSuperClassConstructors(String noPackagesClassName) throws ClassNotFoundException {
        Constructor<?>[] constructors = this.getSuperClass().getDeclaredConstructors();
        if (constructors != null && constructors.length > 0) {
            for (int i = 0; i < constructors.length; ++i) {
                int j;
                Type[] parameters = constructors[i].getGenericParameterTypes();
                Type[] exceptions = constructors[i].getGenericExceptionTypes();
                this.buffer.append("/**\n");
                this.buffer.append(" * Construtor\n");
                if (parameters != null && parameters.length > 0) {
                    for (int p = 0; p < parameters.length; ++p) {
                        this.buffer.append(" * @param param_" + p + " gera\u00e7\u00e3o autom\u00e1tica.\n");
                    }
                    if (exceptions != null && exceptions.length > 0) {
                        for (int e = 0; e < exceptions.length; ++e) {
                            this.buffer.append(" * @throws ");
                            if (exceptions[e] instanceof Class) {
                                this.buffer.append(((Class)exceptions[e]).getName());
                                continue;
                            }
                            this.buffer.append(exceptions[e].toString());
                        }
                        this.buffer.append(" no caso de erro.\n");
                    }
                }
                this.buffer.append(" */\n");
                this.buffer.append("public ");
                this.buffer.append(noPackagesClassName);
                this.buffer.append("(");
                String[] paremeterNames = new String[parameters.length];
                if (parameters != null && parameters.length > 0) {
                    for (j = 0; j < parameters.length; ++j) {
                        if (parameters[j] instanceof Class) {
                            this.buffer.append(this.typeToString((Class)parameters[j]));
                        } else {
                            this.buffer.append(parameters[j].toString());
                        }
                        paremeterNames[j] = "param_" + j;
                        this.buffer.append(" " + paremeterNames[j]);
                        if (j >= parameters.length - 1) break;
                        this.buffer.append(", ");
                    }
                }
                this.buffer.append(") ");
                if (exceptions != null && exceptions.length > 0) {
                    this.buffer.append("throws ");
                    for (j = 0; j < exceptions.length; ++j) {
                        if (exceptions[j] instanceof Class) {
                            this.buffer.append(((Class)exceptions[j]).getName());
                        } else {
                            this.buffer.append(exceptions[j].toString());
                        }
                        if (j >= exceptions.length - 1) break;
                        this.buffer.append(", ");
                    }
                }
                this.buffer.append(" {\n");
                this.buffer.append("  super(");
                if (parameters != null && parameters.length > 0) {
                    for (j = 0; j < parameters.length; ++j) {
                        this.buffer.append(paremeterNames[j]);
                        if (j >= parameters.length - 1) break;
                        this.buffer.append(", ");
                    }
                }
                this.buffer.append(");\n");
                this.getConstructorLines(this.buffer, paremeterNames);
                this.buffer.append("}\n");
            }
        }
    }

    protected void flushToFile(StringBuffer code) {
        String sep = File.separator;
        String[] pathParts = this.genClassName.split("\\.");
        StringBuffer sb = new StringBuffer(pathParts[0]);
        for (int i = 1; i < pathParts.length; ++i) {
            sb.append(sep);
            sb.append(pathParts[i]);
        }
        sb.append(".java");
        String path = sb.toString();
        try {
            Charset cs = Charset.forName("ISO-8859-1");
            CharsetEncoder encoder = cs.newEncoder();
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), encoder)));
            out.print(code.toString());
            if (out.checkError()) {
                System.err.println("Erro gravando arquivo " + path);
            }
            out.close();
        }
        catch (IOException ie) {
            System.err.println("Erro criando arquivo: " + path + " - " + ie.getMessage());
            ie.printStackTrace();
            System.exit(1);
        }
    }

    private final String typeToString(Class type) {
        if (type == null) {
            throw new IllegalArgumentException("type == null");
        }
        String s = "";
        if (!type.isArray()) {
            s = type.getName();
            return s.replace('$', '.');
        }
        while (type != null && type.isArray()) {
            type = type.getComponentType();
            s = s + "[]";
        }
        s = type.getName() + s;
        return s.replace('$', '.');
    }

    protected abstract boolean invokesSuperClassConstructor();

    protected abstract boolean throwsInterfaceExceptions();

    protected String[] getConstructorExceptions() {
        return null;
    }

    protected abstract void getConstructorLines(StringBuffer var1, String[] var2);

    protected abstract void getMethodLines(StringBuffer var1, Method var2, String[] var3);

    protected abstract Class getSuperClass() throws ClassNotFoundException;

    protected abstract String getSuperClassName();

    protected abstract String[] getImports();
}

