/*
 * Decompiled with CFR 0.152.
 */
package csbase.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class IconComposer {
    public static void main(String[] args) throws IOException {
        ImageOptions options = new ImageOptions();
        CmdLineParser parser = new CmdLineParser((Object)options);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("\nIconComposer [options...] arguments...");
            parser.printUsage((OutputStream)System.err);
            System.exit(1);
        }
        if (options.showHelp) {
            System.out.println("\nIconComposer [options...] arguments...");
            parser.printUsage((OutputStream)System.out);
            System.exit(0);
        }
        IconComposer builder = new IconComposer();
        builder.mergeImages(options);
        if (options.showOutput) {
            IconComposer.showImage(options.outputImageFile.getAbsolutePath());
        }
    }

    public static void showImage(String path) {
        JFrame frame = new JFrame(path);
        frame.setPreferredSize(new Dimension(100, 100));
        frame.setDefaultCloseOperation(2);
        JLabel label = new JLabel(new ImageIcon(path));
        frame.add((Component)label, "Center");
        frame.pack();
        frame.setVisible(true);
    }

    public void mergeImages(ImageOptions options) throws IOException {
        BufferedImage backgroundImage = null;
        if (options.backgroundImageFile != null) {
            backgroundImage = ImageIO.read(options.backgroundImageFile);
        }
        BufferedImage foregroundImage = null;
        if (options.foregroundImageFile != null) {
            foregroundImage = ImageIO.read(options.foregroundImageFile);
        }
        BufferedImage decorationImage = null;
        if (options.decorationImageFile != null) {
            decorationImage = ImageIO.read(options.decorationImageFile);
        }
        BufferedImage composedImage = new BufferedImage(options.imageWidth, options.imageHeight, 2);
        Graphics2D graphics = composedImage.createGraphics();
        if (backgroundImage != null) {
            graphics.drawImage(backgroundImage, null, 0, 0);
        }
        if (foregroundImage != null) {
            graphics.drawImage(foregroundImage, null, options.foregroundOffset, options.foregroundOffset);
        }
        if (decorationImage != null) {
            graphics.drawImage(decorationImage, null, options.decorationOffset, options.decorationOffset);
        }
        ImageIO.write((RenderedImage)composedImage, options.imageType, options.outputImageFile);
        graphics.dispose();
    }

    public static class ImageOptions {
        @Option(name="--background", aliases={"-b"}, usage="Set background image file")
        public File backgroundImageFile;
        @Option(name="--foreground", aliases={"-f"}, usage="Set foreground image file")
        public File foregroundImageFile;
        @Option(name="--decoration", aliases={"-d"}, usage="Set decoration image file")
        public File decorationImageFile;
        @Option(name="--output", aliases={"-o"}, usage="Set output image file")
        public File outputImageFile = new File("output.png");
        @Option(name="--type", aliases={"-t"}, usage="Set output image type (jpg, png, gif, bmp)")
        public String imageType = "png";
        @Option(name="--height", aliases={"-h"}, usage="Set output image height (in number of pixels)")
        public int imageHeight = 16;
        @Option(name="--width", aliases={"-w"}, usage="Set output image width (in number of pixels)")
        public int imageWidth = 16;
        @Option(name="--fOffset", aliases={"-fo"}, usage="Set foreground image offset relative to background (in number of pixels)")
        public int foregroundOffset = 5;
        @Option(name="--dOffset", aliases={"-do"}, usage="Set decoration image offset relative to background (in number of pixels)")
        public int decorationOffset = 8;
        @Option(name="--showOutput", aliases={"-s"}, usage="Show output image")
        public boolean showOutput = true;
        @Option(name="--help", usage="Show help")
        boolean showHelp = false;
    }
}

