/*
 * Decompiled with CFR 0.152.
 */
package csbase.tools;

import java.io.IOException;
import java.util.Properties;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.core.properties.PropertiesUtils;
import tecgraf.javautils.core.properties.PropertyException;

public class PropertiesDumper {
    private PropertiesDumper(String[] args) throws PropertyException {
        try {
            Properties props = PropertiesUtils.loadProperties((String)args[0]);
            if (args.length == 1) {
                props.list(System.out);
            } else if (args.length == 2) {
                System.out.println(props.getProperty(args[1]));
            } else {
                for (int i = 1; i < args.length; ++i) {
                    System.out.println(String.format("%s=%s", args[i], props.getProperty(args[i])));
                }
            }
        }
        catch (IOException e) {
            PropertiesDumper.abort(LNG.get((String)"PropertiesDumper.inexistent", (Object[])new String[]{args[0]}), 1);
        }
    }

    private static void abort(String msg, int code) {
        System.err.println(msg);
        System.exit(code);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            PropertiesDumper.abort(LNG.get((String)"PropertiesDumper.usage"), 1);
        }
        try {
            new PropertiesDumper(args);
        }
        catch (PropertyException e) {
            PropertiesDumper.abort(e.getMessage(), 1);
        }
    }
}

