/*
 * Decompiled with CFR 0.152.
 */
package csbase.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class TaskScheduler {
    private final Runnable task;
    private final long period;
    private final TimeUnit unit;
    private final Lock lock;
    private final ScheduledExecutorService executor;
    private ScheduledFuture<?> control;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        this.lock.lock();
        try {
            boolean bl = null != this.control && !this.control.isDone() && !this.control.isCancelled();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean start() {
        this.lock.lock();
        try {
            if (!this.isRunning()) {
                this.control = this.executor.scheduleAtFixedRate(this.task, 0L, this.period, this.unit);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean stop() {
        this.lock.lock();
        try {
            if (this.isRunning()) {
                boolean bl = this.control.cancel(true);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public TaskScheduler(Runnable task, long period, TimeUnit unit) {
        this.task = task;
        this.period = period;
        this.unit = unit;
        this.lock = new ReentrantLock();
        this.executor = Executors.newScheduledThreadPool(1);
    }
}

