/*
 * Decompiled with CFR 0.152.
 */
package csbase.util.messages;

import csbase.util.messages.Message;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import tecgraf.javautils.core.filter.IFilter;

public class MessageStore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(MessageStore.class.getName());
    public static final long MIN_RECEIVE_TIMEOUT = TimeUnit.SECONDS.toMillis(20L);
    public static final long MAX_RECEIVE_TIMEOUT = TimeUnit.MINUTES.toMillis(10L);
    private String name;
    private long receiveTimeout;
    private Map<UUID, Entry> entries;
    private transient ReentrantReadWriteLock entriesLock;
    private Map<Serializable, Long> consumers;
    private transient ReentrantReadWriteLock consumersLock;

    public MessageStore(String name, long receiveTimeout) {
        this.name = name;
        this.entries = new HashMap<UUID, Entry>();
        this.entriesLock = new ReentrantReadWriteLock();
        this.consumers = new HashMap<Serializable, Long>();
        this.consumersLock = new ReentrantReadWriteLock();
        this.setReceiveTimeout(receiveTimeout);
    }

    public String getName() {
        return this.name;
    }

    public void setReceiveTimeout(long timeout) {
        timeout = Math.max(MIN_RECEIVE_TIMEOUT, timeout);
        this.receiveTimeout = Math.min(MAX_RECEIVE_TIMEOUT, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry publish(Message message, long timeToLive) {
        Entry entry = new Entry(message, timeToLive);
        this.entriesLock.writeLock().lock();
        try {
            this.entries.put(message.getId(), entry);
        }
        finally {
            this.entriesLock.writeLock().unlock();
        }
        return entry;
    }

    public Message[] receive(Serializable consumerId, IFilter<Message> filter) {
        return this.get(consumerId, filter, true);
    }

    public Message[] peek(Serializable consumerId, IFilter<Message> filter) {
        return this.get(consumerId, filter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getEntry(UUID messageId) {
        Entry anEntry;
        this.entriesLock.readLock().lock();
        try {
            anEntry = this.entries.get(messageId);
        }
        finally {
            this.entriesLock.readLock().unlock();
        }
        return anEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearExpireds() {
        this.entriesLock.writeLock().lock();
        try {
            Iterator<Map.Entry<UUID, Entry>> iterator = this.entries.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, Entry> anEntry = iterator.next();
                if (!anEntry.getValue().isDiscardable()) continue;
                iterator.remove();
            }
        }
        finally {
            this.entriesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanTimedOutConsumers() {
        this.consumersLock.writeLock().lock();
        try {
            Iterator<Map.Entry<Serializable, Long>> iterator = this.consumers.entrySet().iterator();
            long now = System.currentTimeMillis();
            while (iterator.hasNext()) {
                Map.Entry<Serializable, Long> anEntry = iterator.next();
                long lastReceive = anEntry.getValue();
                if (lastReceive + this.receiveTimeout >= now) continue;
                iterator.remove();
            }
        }
        finally {
            this.consumersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message[] get(Serializable consumerId, IFilter<Message> filter, boolean ack) {
        this.consumersLock.writeLock().lock();
        try {
            this.consumers.put(consumerId, System.currentTimeMillis());
        }
        finally {
            this.consumersLock.writeLock().unlock();
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        this.entriesLock.readLock().lock();
        try {
            for (Entry anEntry : this.entries.values()) {
                if (!filter.accept((Object)anEntry.message) || !anEntry.isAvailableFor(consumerId)) continue;
                messages.add(anEntry.message);
                if (!ack) continue;
                anEntry.setAcknowledgedBy(consumerId);
            }
            Message[] messageArray = messages.toArray(new Message[0]);
            return messageArray;
        }
        finally {
            this.entriesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        LogRecord record;
        this.cleanTimedOutConsumers();
        this.clearExpireds();
        out.writeUTF(this.name);
        out.writeLong(this.receiveTimeout);
        this.entriesLock.readLock().lock();
        try {
            out.writeInt(this.entries.size());
            for (Entry entry : this.entries.values()) {
                try {
                    out.writeObject(entry.message);
                    out.writeLong(entry.expires);
                    out.writeObject(entry.receiveds);
                }
                catch (Exception e) {
                    record = new LogRecord(Level.WARNING, "Error serializing message.");
                    record.setThrown(e);
                    LOGGER.log(record);
                }
            }
        }
        finally {
            this.entriesLock.readLock().unlock();
        }
        this.consumersLock.readLock().lock();
        try {
            out.writeInt(this.consumers.size());
            for (Map.Entry entry : this.consumers.entrySet()) {
                try {
                    out.writeObject(entry.getKey());
                    out.writeLong((Long)entry.getValue());
                }
                catch (Exception e) {
                    record = new LogRecord(Level.WARNING, "Error serializing consumer.");
                    record.setThrown(e);
                    LOGGER.log(record);
                }
            }
        }
        finally {
            this.consumersLock.readLock().unlock();
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        LogRecord record;
        LogRecord record2;
        this.name = "";
        try {
            this.name = in.readUTF();
        }
        catch (Exception e) {
            record2 = new LogRecord(Level.WARNING, "Error deserializing name.");
            record2.setThrown(e);
            LOGGER.log(record2);
        }
        this.receiveTimeout = MAX_RECEIVE_TIMEOUT;
        try {
            this.receiveTimeout = in.readLong();
        }
        catch (Exception e) {
            record2 = new LogRecord(Level.WARNING, "Error deserializing receiveTimeout.");
            record2.setThrown(e);
            LOGGER.log(record2);
        }
        this.entriesLock = new ReentrantReadWriteLock();
        this.entriesLock.writeLock().lock();
        try {
            int entriesSize = 0;
            try {
                entriesSize = in.readInt();
            }
            catch (Exception e) {
                record = new LogRecord(Level.WARNING, "Error deserializing number of messages.");
                record.setThrown(e);
                LOGGER.log(record);
            }
            this.entries = new HashMap<UUID, Entry>(entriesSize);
            for (int inx = 0; inx < entriesSize; ++inx) {
                try {
                    Message message = (Message)in.readObject();
                    long expires = in.readLong();
                    Map receiveds = (Map)in.readObject();
                    Entry entry = new Entry(message, expires, receiveds);
                    this.entries.put(entry.message.getId(), entry);
                    continue;
                }
                catch (Exception e) {
                    LogRecord record3 = new LogRecord(Level.WARNING, "Error deserializing message.");
                    record3.setThrown(e);
                    LOGGER.log(record3);
                }
            }
        }
        finally {
            this.entriesLock.writeLock().unlock();
        }
        this.consumersLock = new ReentrantReadWriteLock();
        this.consumersLock.writeLock().lock();
        try {
            int consumersSize = 0;
            try {
                consumersSize = in.readInt();
            }
            catch (Exception e) {
                record = new LogRecord(Level.WARNING, "Error deserializing number of consumers.");
                record.setThrown(e);
                LOGGER.log(record);
            }
            this.consumers = new HashMap<Serializable, Long>(consumersSize);
            for (int inx = 0; inx < consumersSize; ++inx) {
                try {
                    Serializable key = (Serializable)in.readObject();
                    Long value = in.readLong();
                    this.consumers.put(key, value);
                    continue;
                }
                catch (Exception e) {
                    LogRecord record4 = new LogRecord(Level.WARNING, "Error deserializing consumer.");
                    record4.setThrown(e);
                    LOGGER.log(record4);
                }
            }
        }
        finally {
            this.consumersLock.writeLock().unlock();
        }
        this.cleanTimedOutConsumers();
        this.clearExpireds();
    }

    class Entry {
        private Message message;
        private long expires;
        private Map<Serializable, Boolean> receiveds;
        private Set<Serializable> receiving;

        private Entry(Message message, long expires, Map<Serializable, Boolean> receiveds) {
            this.message = message;
            this.expires = expires;
            this.receiveds = receiveds;
            this.receiving = new HashSet<Serializable>();
        }

        public Entry(Message message, long timeToLive) {
            if (message == null) {
                throw new IllegalArgumentException("message == null");
            }
            if (timeToLive < 0L) {
                throw new IllegalArgumentException("timeToLive < 0");
            }
            this.message = message;
            this.expires = System.currentTimeMillis() + timeToLive;
            this.receiveds = new HashMap<Serializable, Boolean>();
            this.receiving = new HashSet<Serializable>();
        }

        public Message getMessage() {
            return this.message;
        }

        public synchronized boolean setBeingSentTo(Serializable consumerId, boolean sending) {
            if (sending) {
                return this.receiving.add(consumerId);
            }
            return this.receiving.remove(consumerId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void setAcknowledgedBy(Serializable consumerId) {
            long now = System.currentTimeMillis();
            if (this.receiveds.size() == 0) {
                if (this.expires > now) {
                    this.expires = now;
                }
                MessageStore.this.consumersLock.readLock().lock();
                try {
                    for (Map.Entry consumerData : MessageStore.this.consumers.entrySet()) {
                        Serializable aConsumerId = (Serializable)consumerData.getKey();
                        long lastConsume = (Long)consumerData.getValue();
                        if (lastConsume + MessageStore.this.receiveTimeout < now) continue;
                        this.receiveds.put(aConsumerId, false);
                    }
                }
                finally {
                    MessageStore.this.consumersLock.readLock().unlock();
                }
            }
            this.receiveds.put(consumerId, true);
            this.receiving.remove(consumerId);
        }

        public boolean isDiscardable() {
            return this.expires + MessageStore.this.receiveTimeout <= System.currentTimeMillis();
        }

        public synchronized boolean isAvailableFor(Serializable consumerId) {
            long now = System.currentTimeMillis();
            if (this.receiving.contains(consumerId)) {
                return false;
            }
            if (this.expires > now) {
                return true;
            }
            if (this.expires + MessageStore.this.receiveTimeout < now) {
                return false;
            }
            if (this.receiveds.size() == 0) {
                return true;
            }
            Boolean ack = this.receiveds.get(consumerId);
            return ack != null && ack == false;
        }
    }
}

