package csbase.util.messages.filters;

import java.io.Serializable;

import tecgraf.javautils.core.filter.IFilter;
import csbase.util.messages.Message;

/**
 * Filtra mensagens de acordo com a classe do corpo.
 * 
 * @author Tecgraf
 */
public class BodyTypeFilter implements IFilter<Message>, Serializable {

  /**
   * Classe ou ancestral da classe que o corpo das mensagens de interesse deve
   * ter.
   */
  private Class<?> bodyType;

  /**
   * Construtor.
   * 
   * @param bodyType Classe ou ancestral da classe que o corpo das mensagens de
   *        interesse deve ter.
   */
  public BodyTypeFilter(Class<?> bodyType) {
    this.bodyType = bodyType;
  }

  /**
   * Filtra mensagens de acordo com a classe do corpo. Se o corpo da mensagem
   * for da mesma classe ou descender da classe passada no construtor do filtro,
   * essa mensagem ser aceita.
   * 
   * {@inheritDoc}
   */
  @Override
  public boolean accept(Message message) {
    return bodyType.isAssignableFrom(message.getBody().getClass());
  }
}
