/*
 * Decompiled with CFR 0.152.
 */
package csbase.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import tecgraf.javautils.core.io.FileUtils;

public final class Unzip {
    private static final int BUFFER_SIZE = 65536;
    private File file;

    public Unzip(File file) {
        if (file == null) {
            throw new IllegalArgumentException("O par\u00e2metro file est\u00e1 nulo.");
        }
        this.file = file;
    }

    public void decompress(File outputDir) throws IOException {
        this.decompress(outputDir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decompress(File outputDirectory, boolean useDirectoryStructure) throws IOException {
        if (outputDirectory == null) {
            throw new IllegalArgumentException("O par\u00e2metro outputDirectory est\u00e1 nulo.");
        }
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        ZipInputStream zipInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                this.unzipZipEntry(zipInputStream, zipEntry, outputDirectory, useDirectoryStructure);
                zipInputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (Throwable throwable) {
            this.closeQuietly(zipInputStream, bufferedInputStream, fileInputStream);
            throw throwable;
        }
        this.closeQuietly(zipInputStream, bufferedInputStream, fileInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ZipEntry> listZipEntries() throws IOException {
        List<ZipEntry> list;
        LinkedList<ZipEntry> zipEntries = new LinkedList<ZipEntry>();
        ZipInputStream zin = null;
        try {
            ZipEntry zipEntry;
            FileInputStream fin = new FileInputStream(this.file);
            zin = new ZipInputStream(fin);
            while (null != (zipEntry = zin.getNextEntry())) {
                zipEntries.add(zipEntry);
            }
            list = Collections.unmodifiableList(zipEntries);
        }
        catch (Throwable throwable) {
            this.closeQuietly(zin);
            throw throwable;
        }
        this.closeQuietly(zin);
        return list;
    }

    private void closeQuietly(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            zipFile = null;
        }
    }

    private void closeQuietly(InputStream ... inputStreams) {
        for (InputStream inputStream : inputStreams) {
            if (inputStream == null) continue;
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
    }

    private void closeQuietly(OutputStream ... outputStreams) {
        for (OutputStream outputStream : outputStreams) {
            if (outputStream == null) continue;
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unzipZipEntry(ZipInputStream zipInputStream, ZipEntry zipEntry, File outputDirectory, boolean useDirectoryStructure) throws IOException {
        String filePath;
        if (useDirectoryStructure) {
            filePath = zipEntry.getName();
        } else {
            String[] zipFilePath = FileUtils.splitPath((String)zipEntry.getName(), (String)"/");
            filePath = zipFilePath[zipFilePath.length - 1];
        }
        File outputFile = new File(outputDirectory, filePath);
        if (zipEntry.isDirectory()) {
            if (outputFile.exists()) return;
            outputFile.mkdirs();
            return;
        }
        File parentFile = new File(outputFile.getParent());
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        byte[] buffer = new byte[65536];
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            int size;
            fileOutputStream = new FileOutputStream(outputFile);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            while ((size = zipInputStream.read(buffer, 0, buffer.length)) != -1) {
                bufferedOutputStream.write(buffer, 0, size);
            }
            bufferedOutputStream.flush();
        }
        catch (Throwable throwable) {
            this.closeQuietly(bufferedOutputStream, fileOutputStream);
            throw throwable;
        }
        this.closeQuietly(bufferedOutputStream, fileOutputStream);
    }
}

