package csbase.util.data.dispatcher;

import java.util.concurrent.ExecutorService;


/**
 * Decora um {@link IDispatcher despachantes}, utilizando um
 * {@link ExecutorService executor} para fazer a entrega das mensagens.
 * 
 * @param <T> Tipo do destino.
 * @param <D> Tipo dos dados a serem despachados para o destino.
 * 
 * @author Tecgraf
 */
public class ExecutorDispatcher<T, D> implements IDispatcher<T, D> {

  /**
   * Responsvel por executar a entrega das mensagens.
   */
  private ExecutorService executor;

  /**
   * Despachante sendo decorado.
   */
  private IDispatcher<T, D> decorated;

  /**
   * Construtor.
   * 
   * @param executor Responsvel por executar a entrega das mensagens.
   * @param decorated Despachante sendo decorado.
   */
  public ExecutorDispatcher(ExecutorService executor,
    IDispatcher<T, D> decorated) {
    this.executor = executor;
    this.decorated = decorated;
  }

  /**
   * <p>
   * Utiliza um executor para entregar os dados.
   * </p>
   * {@inheritDoc}
   */
  @Override
  public void dispatch(final IDispatchListener<T, D> callback,
    final T destination, final D... data) {
    Runnable runnable = new Runnable() {
      @Override
      public void run() {
        decorated.dispatch(callback, destination, data);
      }
    };
    executor.execute(runnable);
  }
}
