/*
 * Decompiled with CFR 0.152.
 */
package csbase.util.data.channel;

import csbase.util.data.dispatcher.IDispatchListener;
import csbase.util.data.dispatcher.IDispatcher;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import tecgraf.javautils.core.filter.IFilter;

public class DataChannel<S, D> {
    private IDispatcher<S, D> dispatcher;
    private IDispatchListener<S, D> dispatchListener;
    private List<DataObserver> observers;
    private Observable dataNotifier;

    public DataChannel(IDispatcher<S, D> dispatcher, IDispatchListener<S, D> dispatchListener) {
        this.dispatcher = dispatcher;
        this.dispatchListener = dispatchListener;
        this.observers = new ArrayList<DataObserver>();
        this.dataNotifier = new Observable(){

            @Override
            public void notifyObservers(Object arg) {
                this.setChanged();
                super.notifyObservers(arg);
            }
        };
    }

    public void publish(D ... data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (data.length > 0) {
            this.dataNotifier.notifyObservers(data);
        }
    }

    public synchronized int subscribe(S subscriber, IFilter<D> selector) throws IllegalArgumentException {
        if (subscriber == null) {
            throw new NullPointerException("subscriber == null");
        }
        if (selector == null) {
            throw new NullPointerException("selector == null");
        }
        for (DataObserver anObserver : this.observers) {
            if (!anObserver.subscriber.equals(subscriber)) continue;
            throw new IllegalArgumentException("Assinante j\u00e1 cadastrado.");
        }
        DataObserver observer = new DataObserver(subscriber, selector);
        this.observers.add(observer);
        this.dataNotifier.addObserver(observer);
        return this.observers.size();
    }

    public synchronized int unsubscribe(S subscriber) {
        if (subscriber == null) {
            throw new NullPointerException("listener == null");
        }
        Iterator<DataObserver> iter = this.observers.iterator();
        while (iter.hasNext()) {
            DataObserver observer = iter.next();
            if (!observer.subscriber.equals(subscriber)) continue;
            iter.remove();
            this.dataNotifier.deleteObserver(observer);
            break;
        }
        return this.observers.size();
    }

    public void unsubscribeAll() {
        this.observers.clear();
        this.dataNotifier.deleteObservers();
    }

    public int countListeners() {
        return this.observers.size();
    }

    private class DataObserver
    implements Observer {
        private S subscriber;
        private IFilter<D> selector;

        DataObserver(S subscriber, IFilter<D> selector) {
            this.subscriber = subscriber;
            this.selector = selector;
        }

        @Override
        public void update(Observable o, Object arg) {
            Object[] data = (Object[])arg;
            ArrayList<Object> accepteds = new ArrayList<Object>();
            for (Object aData : data) {
                if (!this.selector.accept(aData)) continue;
                accepteds.add(aData);
            }
            if (accepteds.size() == 0) {
                return;
            }
            if (accepteds.size() == data.length) {
                DataChannel.this.dispatcher.dispatch(DataChannel.this.dispatchListener, this.subscriber, data);
            } else {
                Class<?> dataType = data.getClass().getComponentType();
                Object[] acceptedsArray = (Object[])Array.newInstance(dataType, accepteds.size());
                accepteds.toArray(acceptedsArray);
                DataChannel.this.dispatcher.dispatch(DataChannel.this.dispatchListener, this.subscriber, acceptedsArray);
            }
        }
    }
}

