/*
 * Decompiled with CFR 0.152.
 */
package validations;

import csbase.util.FileSystemUtils;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import validations.AbstractValidation;
import validations.util.ValidatorUtils;

public final class PersistencyMoveValidation
extends AbstractValidation {
    private static final String BCK_USERDATA_SUBDIR_NAME = "usersdata";
    private static final String BCK_SHROBJS_SUBDIR_NAME = "shared-objects";
    private static final String BCK_PERS_SUBDIR_NAME = "persistent-data";
    private static final String NEW_PERS_DIR_PROP = "Persistency.newDirectory";
    private static final String OLD_PERS_DIR_PROP = "Persistency.oldDirectory";
    private static final String OLD_SHR_OBJ_DIR_PROP = "SharedObjects.oldDirectory";
    private static final String OLD_USR_DAT_DIR_PROP = "UsersData.oldDirectory";

    @Override
    protected boolean applyPatch() {
        File oldUsrDatDir = this.getFileProperty(OLD_USR_DAT_DIR_PROP);
        File oldShrObjDir = this.getFileProperty(OLD_SHR_OBJ_DIR_PROP);
        File newUsrDatDir = this.getNewUsersDataDir();
        File newShrObjDir = this.getNewSharedObjectsDir();
        File newPersDir = this.getFileProperty(NEW_PERS_DIR_PROP);
        if (FileSystemUtils.dirExists((File)newPersDir)) {
            String path = newPersDir.getAbsolutePath();
            this.logger.severe("Ja existe novo diretorio: " + path);
            return false;
        }
        if (!newPersDir.mkdirs()) {
            String path = newPersDir.getAbsolutePath();
            this.logger.severe("Falha na cria\u00e7\u00e3o de: " + path);
            return false;
        }
        if (!this.move(oldUsrDatDir, newUsrDatDir)) {
            return false;
        }
        if (!this.move(oldShrObjDir, newShrObjDir)) {
            return false;
        }
        File oldPersDir = this.getFileProperty(OLD_PERS_DIR_PROP);
        File[] children = oldPersDir.listFiles();
        String sep = File.separator;
        if (children != null && children.length > 0) {
            for (File child : children) {
                String fileName = child.getName();
                String newPath = newPersDir.getAbsolutePath() + sep + fileName;
                File newFile = new File(newPath);
                String fmt = "Movendo elemento [%s] para novo diret\u00f3rio";
                String msg = String.format("Movendo elemento [%s] para novo diret\u00f3rio", newFile.getName());
                this.logger.fine(msg);
                if (child.renameTo(newFile)) continue;
                String path = newPersDir.getAbsolutePath();
                this.logger.severe("Falha no move interno de: " + path);
                return false;
            }
        }
        FileSystemUtils.deleteRecursively((File)oldPersDir, (Logger)this.logger);
        return true;
    }

    @Override
    protected void finish() {
    }

    private File getFileProperty(String propName) {
        String dirPath = this.getMandatorySystemProperty(propName);
        if (dirPath == null) {
            return null;
        }
        File dir = new File(dirPath);
        return dir;
    }

    private File getNewSharedObjectsDir() {
        File newPersDir = this.getFileProperty(NEW_PERS_DIR_PROP);
        String subDirName = BCK_SHROBJS_SUBDIR_NAME;
        String newUsrDatDirPath = newPersDir + File.separator + BCK_SHROBJS_SUBDIR_NAME;
        return new File(newUsrDatDirPath);
    }

    private File getNewUsersDataDir() {
        File newPersDir = this.getFileProperty(NEW_PERS_DIR_PROP);
        String subDirName = "sga-groups";
        String newUsrDatDirPath = newPersDir + File.separator + "sga-groups";
        return new File(newUsrDatDirPath);
    }

    @Override
    protected void getSpecificFailureMessage(AbstractValidation.Status status, List<String> errors) {
        switch (status) {
            case VALIDATION_FAILED: {
                errors.add("*** ESTRUTURA DE PERSISTENCIA NO FORMATO ANTIGO");
                break;
            }
            case PATCH_FAILED: {
                errors.add("*** A CONVERS\u00c3O DA PERSIST\u00caNCIA RESULTOU EM ERRO");
                break;
            }
            case INIT_FAILED: {
                errors.add("*** FALHA NA INICIALIZA\u00c7\u00c3O");
                break;
            }
            default: {
                errors.add("ESTADO INV\u00c1LIDO: " + status.toString());
            }
        }
    }

    @Override
    protected String getStartMessage() {
        return "Convertendo estrutura de persist\u00eancia do servidor";
    }

    @Override
    protected String getSuccessMessage(AbstractValidation.Status status) {
        switch (status) {
            case VALIDATION_OK: {
                return "*** REESTRUTURA\u00c7\u00c3O DE PERSIST\u00caNCIA J\u00c1 FOI FEITA";
            }
            case PATCH_OK: {
                return "*** REESTRUTURA\u00c7\u00c3O DE PERSIST\u00caNCIA REALIZADA COM SUCESSO";
            }
        }
        return "ESTADO INV\u00c1LIDO: " + status.toString();
    }

    @Override
    protected boolean init() {
        String oPath;
        File oldPersDir = this.getFileProperty(OLD_PERS_DIR_PROP);
        File newPersDir = this.getFileProperty(NEW_PERS_DIR_PROP);
        File oldShrObjDir = this.getFileProperty(OLD_SHR_OBJ_DIR_PROP);
        File oldUsrDatDir = this.getFileProperty(OLD_USR_DAT_DIR_PROP);
        if (oldShrObjDir == null || newPersDir == null || oldUsrDatDir == null || oldPersDir == null) {
            return false;
        }
        String nPath = newPersDir.getAbsolutePath();
        if (nPath.equals(oPath = oldPersDir.getAbsolutePath())) {
            String msg = "O novo diret\u00f3rio de persist\u00eancia n\u00e3o pode ser o mesmo do antigo!";
            this.logger.severe("O novo diret\u00f3rio de persist\u00eancia n\u00e3o pode ser o mesmo do antigo!");
            return false;
        }
        return true;
    }

    private boolean move(File srcDir, File dstDir) {
        String srcPath = srcDir.getAbsolutePath();
        String destPath = dstDir.getAbsolutePath();
        if (!srcDir.renameTo(dstDir)) {
            this.logger.severe("Falha no move: " + srcPath + " para " + destPath);
            return false;
        }
        this.logger.fine("Movendo " + srcPath + " -> " + destPath);
        return true;
    }

    @Override
    protected boolean backupData() {
        String bckPath = this.getBackupDirPath();
        String sep = File.separator;
        File oldUsrDatDir = this.getFileProperty(OLD_USR_DAT_DIR_PROP);
        String bckUsrDatPath = bckPath + sep + BCK_USERDATA_SUBDIR_NAME;
        File bckUsrDatDir = new File(bckUsrDatPath);
        FileSystemUtils.deleteRecursively((File)bckUsrDatDir, (Logger)this.logger);
        ValidatorUtils.copyDirectory(oldUsrDatDir, bckUsrDatDir, this.logger);
        File oldShrObjDir = this.getFileProperty(OLD_SHR_OBJ_DIR_PROP);
        String bckShrObjPath = bckPath + sep + BCK_SHROBJS_SUBDIR_NAME;
        File bckShrObjDir = new File(bckShrObjPath);
        FileSystemUtils.deleteRecursively((File)bckShrObjDir, (Logger)this.logger);
        ValidatorUtils.copyDirectory(oldShrObjDir, bckShrObjDir, this.logger);
        File oldPersDir = this.getFileProperty(OLD_PERS_DIR_PROP);
        String bckPersPath = bckPath + sep + BCK_PERS_SUBDIR_NAME;
        File bckPersDir = new File(bckPersPath);
        FileSystemUtils.deleteRecursively((File)bckPersDir, (Logger)this.logger);
        ValidatorUtils.copyDirectory(oldPersDir, bckPersDir, this.logger);
        return true;
    }

    @Override
    protected boolean restoreBackup() {
        String bckPath = this.getBackupDirPath();
        String sep = File.separator;
        File newPersDir = this.getFileProperty(NEW_PERS_DIR_PROP);
        FileSystemUtils.deleteRecursively((File)newPersDir, (Logger)this.logger);
        File oldUsrDatDir = this.getFileProperty(OLD_USR_DAT_DIR_PROP);
        String bckUsrDatPath = bckPath + sep + BCK_USERDATA_SUBDIR_NAME;
        File bckUsrDatDir = new File(bckUsrDatPath);
        FileSystemUtils.deleteRecursively((File)oldUsrDatDir, (Logger)this.logger);
        ValidatorUtils.copyDirectory(bckUsrDatDir, oldUsrDatDir, this.logger);
        File oldShrObjDir = this.getFileProperty(OLD_SHR_OBJ_DIR_PROP);
        String bckShrObjPath = bckPath + sep + BCK_SHROBJS_SUBDIR_NAME;
        File bckShrObjDir = new File(bckShrObjPath);
        FileSystemUtils.deleteRecursively((File)oldShrObjDir, (Logger)this.logger);
        ValidatorUtils.copyDirectory(bckShrObjDir, oldShrObjDir, this.logger);
        File oldPersDir = this.getFileProperty(OLD_PERS_DIR_PROP);
        String bckPersPath = bckPath + sep + BCK_PERS_SUBDIR_NAME;
        File bckPersDir = new File(bckPersPath);
        FileSystemUtils.deleteRecursively((File)oldPersDir, (Logger)this.logger);
        ValidatorUtils.copyDirectory(bckPersDir, oldPersDir, this.logger);
        return true;
    }

    @Override
    protected boolean validate() {
        File newPersDir = this.getFileProperty(NEW_PERS_DIR_PROP);
        File newUsrDatDir = this.getNewUsersDataDir();
        File newShrObjDir = this.getNewSharedObjectsDir();
        if (FileSystemUtils.dirExists((File)newPersDir) && FileSystemUtils.dirExists((File)newUsrDatDir) && FileSystemUtils.dirExists((File)newShrObjDir)) {
            this.logger.info("Novos diret\u00f3rios de persist\u00eancia j\u00e1 existem. VALIDADO!");
            return true;
        }
        File oldPersDir = this.getFileProperty(OLD_PERS_DIR_PROP);
        File oldShrObjDir = this.getFileProperty(OLD_SHR_OBJ_DIR_PROP);
        File oldUsrDatDir = this.getFileProperty(OLD_USR_DAT_DIR_PROP);
        if (!(FileSystemUtils.dirExists((File)oldPersDir) || FileSystemUtils.dirExists((File)oldUsrDatDir) || FileSystemUtils.dirExists((File)oldShrObjDir))) {
            this.logger.info("N\u00e3o existem os diret\u00f3rios de persist\u00eancia no formato antigo. VALIDADO!");
            return true;
        }
        return false;
    }

    @Override
    protected boolean runsOnlyOnce() {
        return true;
    }
}

