/*
 * Decompiled with CFR 0.152.
 */
package validations.util;

import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class ValidationsLogger
extends Logger {
    private static final String SECTION_SEPARATOR = "==============================================================";
    private static final String SIMPLE_SEPARATOR = "--------------------------------------------------------------";
    private static Formatter LOG_FORMATTER = new Formatter(){

        @Override
        public String format(LogRecord record) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(record.getLevel().getLocalizedName());
            buffer.append(": ");
            buffer.append(record.getMessage());
            buffer.append('\n');
            return buffer.toString();
        }
    };
    private final ConsoleHandler consoleHandler;
    private FileHandler fileHandler;
    private String logFilePath;

    public ValidationsLogger() {
        super(ValidationsLogger.class.getName(), null);
        this.setUseParentHandlers(false);
        this.consoleHandler = new ConsoleHandler();
        this.consoleHandler.setFormatter(LOG_FORMATTER);
        this.addHandler(this.consoleHandler);
        super.setLevel(Level.FINE);
    }

    public boolean setFileHandler(String logFilePath) {
        if (this.fileHandler != null) {
            this.fileHandler.close();
            this.removeHandler(this.fileHandler);
        }
        try {
            this.fileHandler = new FileHandler(logFilePath, true);
        }
        catch (Exception e) {
            this.severe("Erro configurando log para o arquivo " + logFilePath);
            this.severe(e.toString());
            return false;
        }
        this.fileHandler.setFormatter(LOG_FORMATTER);
        this.fileHandler.setLevel(Level.FINE);
        this.addHandler(this.fileHandler);
        this.logFilePath = logFilePath;
        return true;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void separator(Level level) {
        this.log(level, SIMPLE_SEPARATOR);
    }

    public void blank(Level level) {
        this.log(level, "");
    }

    public void sectionSeparator(Level level) {
        this.log(level, SECTION_SEPARATOR);
    }

    public void setConsoleLevel(Level level) {
        this.consoleHandler.setLevel(level);
    }

    public void toConsole(String msg) {
        this.publish(this.consoleHandler, msg);
    }

    public void toFile(String msg) {
        if (this.fileHandler != null) {
            this.publish(this.fileHandler, msg);
        }
    }

    private void publish(Handler handler, String msg) {
        handler.publish(new LogRecord(handler.getLevel(), msg));
    }

    public void close() {
        this.consoleHandler.close();
        if (this.fileHandler != null) {
            this.fileHandler.close();
        }
    }

    @Override
    public Level getLevel() {
        return this.consoleHandler.getLevel();
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        this.consoleHandler.setLevel(newLevel);
    }

    public void disable() {
        this.consoleHandler.setLevel(Level.OFF);
        this.fileHandler.setLevel(Level.OFF);
    }

    public void enable(Level level) {
        this.fileHandler.setLevel(Level.FINE);
        this.consoleHandler.setLevel(level);
    }

    public void exception(Throwable e) {
        this.severe(e.getClass().getName() + " (mais detalhes no arquivo de log)");
        StringBuilder buffer = new StringBuilder("Pilha de execu\u00e7\u00e3o:");
        this.collectStackTrace(buffer, e);
        this.fine(buffer.toString());
    }

    private void collectStackTrace(StringBuilder buffer, Throwable e) {
        StackTraceElement[] stackTrace;
        if (e == null) {
            return;
        }
        buffer.append('\n');
        buffer.append(e.getClass().getName() + " - " + e.getMessage());
        for (StackTraceElement ste : stackTrace = e.getStackTrace()) {
            buffer.append("\n    ");
            buffer.append(ste.toString());
        }
        this.collectStackTrace(buffer, e.getCause());
    }

    public void exception(String msg, Throwable e) {
        this.severe(msg);
        this.exception(e);
    }
}

