/*
 * Decompiled with CFR 0.152.
 */
package csfs.impl.util;

import csfs.impl.util.SystemProperties;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;

public class ExternalCommandRunner
extends Thread {
    private String[] cmd;
    private boolean finished;
    private boolean normalTermination;

    public ExternalCommandRunner(String[] cmd) {
        this.cmd = cmd;
    }

    public synchronized boolean myWaitFor() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return this.normalTermination;
    }

    public synchronized void notifyEnd() {
        System.out.println("ExternalCommandRunner: END!");
        this.finished = true;
        this.notifyAll();
    }

    @Override
    public void run() {
        try {
            final Process p = Runtime.getRuntime().exec(this.cmd, null, new File(SystemProperties.getProperty("ROOT_DIR")));
            System.out.println("ExternalCommandRunner: START!!!");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        int c;
                        BufferedInputStream in = new BufferedInputStream(p.getInputStream());
                        while ((c = in.read()) != -1) {
                            System.out.print((char)c);
                        }
                        in.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }).start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        int c;
                        BufferedInputStream in = new BufferedInputStream(p.getErrorStream());
                        while ((c = in.read()) != -1) {
                            System.err.print((char)c);
                        }
                        in.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }).start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (!ExternalCommandRunner.this.finished) {
                            Thread.sleep(300000L);
                            if (ExternalCommandRunner.this.finished) continue;
                            Process p2 = Runtime.getRuntime().exec(new String[]{"sh", "/home/prj/csbase/mnery/working_area/remotefilesystem/ps.sh"});
                            BufferedReader in2 = new BufferedReader(new InputStreamReader(p2.getInputStream()));
                            String response = in2.readLine();
                            response = response.trim();
                            System.out.println("ps output:" + response);
                            if (!response.startsWith("0")) continue;
                            System.out.println("WHERE IS THE PROCESS???");
                            ExternalCommandRunner.this.normalTermination = false;
                            ExternalCommandRunner.this.notifyEnd();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }).start();
            int exitValue = p.waitFor();
            this.normalTermination = true;
            this.notifyEnd();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

