/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.MapFactory;

public class CollectionComponentParameter
implements Parameter,
Serializable {
    private static final MapFactory mapFactory = new MapFactory();
    public static final CollectionComponentParameter ARRAY = new CollectionComponentParameter();
    public static final CollectionComponentParameter ARRAY_ALLOW_EMPTY = new CollectionComponentParameter(true);
    private final boolean emptyCollection;
    private final Class componentKeyType;
    private final Class componentValueType;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$reflect$Array;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$SortedSet;
    static /* synthetic */ Class class$java$util$TreeSet;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$SortedMap;
    static /* synthetic */ Class class$java$util$TreeMap;
    static /* synthetic */ Class class$java$util$HashMap;

    public CollectionComponentParameter() {
        this(false);
    }

    public CollectionComponentParameter(boolean bl) {
        this(Void.TYPE, bl);
    }

    public CollectionComponentParameter(Class clazz, boolean bl) {
        this(class$java$lang$Object == null ? (class$java$lang$Object = CollectionComponentParameter.class$("java.lang.Object")) : class$java$lang$Object, clazz, bl);
    }

    public CollectionComponentParameter(Class clazz, Class clazz2, boolean bl) {
        this.emptyCollection = bl;
        this.componentKeyType = clazz;
        this.componentValueType = clazz2;
    }

    public Object resolveInstance(PicoContainer picoContainer, ComponentAdapter componentAdapter, Class clazz) {
        Object object = null;
        Class clazz2 = this.getCollectionType(clazz);
        if (clazz2 != null) {
            Map map = this.getMatchingComponentAdapters(picoContainer, componentAdapter, this.componentKeyType, this.getValueType(clazz));
            if ((class$java$lang$reflect$Array == null ? (class$java$lang$reflect$Array = CollectionComponentParameter.class$("java.lang.reflect.Array")) : class$java$lang$reflect$Array).isAssignableFrom(clazz2)) {
                object = this.getArrayInstance(picoContainer, clazz, map);
            } else if ((class$java$util$Map == null ? (class$java$util$Map = CollectionComponentParameter.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz2)) {
                object = this.getMapInstance(picoContainer, clazz, map);
            } else if ((class$java$util$Collection == null ? (class$java$util$Collection = CollectionComponentParameter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz2)) {
                object = this.getCollectionInstance(picoContainer, clazz, map);
            } else {
                throw new PicoIntrospectionException(clazz.getName() + " is not a collective type");
            }
        }
        return object;
    }

    public boolean isResolvable(PicoContainer picoContainer, ComponentAdapter componentAdapter, Class clazz) {
        Class clazz2 = this.getCollectionType(clazz);
        Class clazz3 = this.getValueType(clazz);
        return clazz2 != null && (this.emptyCollection || this.getMatchingComponentAdapters(picoContainer, componentAdapter, this.componentKeyType, clazz3).size() > 0);
    }

    public void verify(PicoContainer picoContainer, ComponentAdapter componentAdapter, Class clazz) {
        Class clazz2 = this.getCollectionType(clazz);
        if (clazz2 != null) {
            Class clazz3 = this.getValueType(clazz);
            Collection collection = this.getMatchingComponentAdapters(picoContainer, componentAdapter, this.componentKeyType, clazz3).values();
            if (collection.isEmpty()) {
                if (!this.emptyCollection) {
                    throw new PicoIntrospectionException(clazz.getName() + " not resolvable, no components of type " + this.getValueType(clazz).getName() + " available");
                }
            } else {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    ComponentAdapter componentAdapter2 = (ComponentAdapter)iterator.next();
                    componentAdapter2.verify(picoContainer);
                }
            }
        } else {
            throw new PicoIntrospectionException(clazz.getName() + " is not a collective type");
        }
    }

    public void accept(PicoVisitor picoVisitor) {
        picoVisitor.visitParameter(this);
    }

    protected boolean evaluate(ComponentAdapter componentAdapter) {
        return componentAdapter != null;
    }

    protected Map getMatchingComponentAdapters(PicoContainer picoContainer, ComponentAdapter componentAdapter, Class clazz, Class clazz2) {
        Object object;
        Map map = mapFactory.newInstance();
        PicoContainer picoContainer2 = picoContainer.getParent();
        if (picoContainer2 != null) {
            map.putAll(this.getMatchingComponentAdapters(picoContainer2, componentAdapter, clazz, clazz2));
        }
        Collection collection = picoContainer.getComponentAdapters();
        Object object2 = collection.iterator();
        while (object2.hasNext()) {
            object = (ComponentAdapter)object2.next();
            map.remove(object.getComponentKey());
        }
        object2 = picoContainer.getComponentAdaptersOfType(clazz2);
        object = object2.iterator();
        while (object.hasNext()) {
            ComponentAdapter componentAdapter2 = (ComponentAdapter)object.next();
            Object object3 = componentAdapter2.getComponentKey();
            if (componentAdapter != null && object3.equals(componentAdapter.getComponentKey()) || !clazz.isAssignableFrom(object3.getClass()) || !this.evaluate(componentAdapter2)) continue;
            map.put(object3, componentAdapter2);
        }
        return map;
    }

    private Class getCollectionType(Class clazz) {
        Class clazz2 = null;
        if (clazz.isArray()) {
            clazz2 = class$java$lang$reflect$Array == null ? (class$java$lang$reflect$Array = CollectionComponentParameter.class$("java.lang.reflect.Array")) : class$java$lang$reflect$Array;
        } else if ((class$java$util$Map == null ? (class$java$util$Map = CollectionComponentParameter.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz)) {
            clazz2 = class$java$util$Map == null ? (class$java$util$Map = CollectionComponentParameter.class$("java.util.Map")) : class$java$util$Map;
        } else if ((class$java$util$Collection == null ? (class$java$util$Collection = CollectionComponentParameter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
            clazz2 = class$java$util$Collection == null ? (class$java$util$Collection = CollectionComponentParameter.class$("java.util.Collection")) : class$java$util$Collection;
        }
        return clazz2;
    }

    private Class getValueType(Class clazz) {
        Class<?> clazz2 = this.componentValueType;
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
        }
        return clazz2;
    }

    private Object[] getArrayInstance(PicoContainer picoContainer, Class clazz, Map map) {
        Object[] objectArray = (Object[])Array.newInstance(clazz.getComponentType(), map.size());
        int n = 0;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            objectArray[n] = picoContainer.getComponentInstance(componentAdapter.getComponentKey());
            ++n;
        }
        return objectArray;
    }

    private Collection getCollectionInstance(PicoContainer picoContainer, Class clazz, Map map) {
        Class clazz2 = clazz;
        if (clazz2.isInterface()) {
            if ((class$java$util$List == null ? (class$java$util$List = CollectionComponentParameter.class$("java.util.List")) : class$java$util$List).isAssignableFrom(clazz2)) {
                clazz2 = class$java$util$ArrayList == null ? (class$java$util$ArrayList = CollectionComponentParameter.class$("java.util.ArrayList")) : class$java$util$ArrayList;
            } else if ((class$java$util$SortedSet == null ? (class$java$util$SortedSet = CollectionComponentParameter.class$("java.util.SortedSet")) : class$java$util$SortedSet).isAssignableFrom(clazz2)) {
                clazz2 = class$java$util$TreeSet == null ? (class$java$util$TreeSet = CollectionComponentParameter.class$("java.util.TreeSet")) : class$java$util$TreeSet;
            } else if ((class$java$util$Set == null ? (class$java$util$Set = CollectionComponentParameter.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(clazz2)) {
                clazz2 = class$java$util$HashSet == null ? (class$java$util$HashSet = CollectionComponentParameter.class$("java.util.HashSet")) : class$java$util$HashSet;
            } else if ((class$java$util$Collection == null ? (class$java$util$Collection = CollectionComponentParameter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz2)) {
                clazz2 = class$java$util$ArrayList == null ? (class$java$util$ArrayList = CollectionComponentParameter.class$("java.util.ArrayList")) : class$java$util$ArrayList;
            }
        }
        try {
            Collection collection = (Collection)clazz2.newInstance();
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
                collection.add(picoContainer.getComponentInstance(componentAdapter.getComponentKey()));
            }
            return collection;
        }
        catch (InstantiationException instantiationException) {
            throw new PicoInitializationException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PicoInitializationException(illegalAccessException);
        }
    }

    private Map getMapInstance(PicoContainer picoContainer, Class clazz, Map map) {
        Class clazz2 = clazz;
        if (clazz2.isInterface()) {
            if ((class$java$util$SortedMap == null ? (class$java$util$SortedMap = CollectionComponentParameter.class$("java.util.SortedMap")) : class$java$util$SortedMap).isAssignableFrom(clazz2)) {
                clazz2 = class$java$util$TreeMap == null ? (class$java$util$TreeMap = CollectionComponentParameter.class$("java.util.TreeMap")) : class$java$util$TreeMap;
            } else if ((class$java$util$Map == null ? (class$java$util$Map = CollectionComponentParameter.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz2)) {
                clazz2 = class$java$util$HashMap == null ? (class$java$util$HashMap = CollectionComponentParameter.class$("java.util.HashMap")) : class$java$util$HashMap;
            }
        }
        try {
            Map map2 = (Map)clazz2.newInstance();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                map2.put(k, picoContainer.getComponentInstance(k));
            }
            return map2;
        }
        catch (InstantiationException instantiationException) {
            throw new PicoInitializationException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PicoInitializationException(illegalAccessException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

