/*
 * Decompiled with CFR 0.152.
 */
package csfs.datatransfer.blockingnio;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;

public class BlockingNIOSenderThread
extends Thread {
    private InetSocketAddress targetAddress;
    private File localFile;
    private long length;
    private String targetFilename;

    public BlockingNIOSenderThread(InetSocketAddress targetAddress, File localFile, long length, String targetFilename) {
        this.targetAddress = targetAddress;
        this.localFile = localFile;
        this.length = length;
        this.targetFilename = targetFilename;
    }

    @Override
    public void run() {
        try {
            SocketChannel socketChannel = SocketChannel.open(this.targetAddress);
            FileInputStream file = new FileInputStream(this.localFile);
            FileChannel fileChannel = file.getChannel();
            String initProtocol = "" + this.length + "\n" + this.targetFilename + "\n";
            int headerSize = initProtocol.length();
            String headerSizeStr = headerSize + "\n";
            ByteBuffer headerLength = ByteBuffer.allocate(7);
            headerLength.put(headerSizeStr.getBytes());
            headerLength.rewind();
            socketChannel.write(headerLength);
            ByteBuffer out = ByteBuffer.allocate(initProtocol.length());
            out.put(initProtocol.getBytes());
            out.rewind();
            socketChannel.write(out);
            fileChannel.transferTo(0L, this.length, socketChannel);
            fileChannel.close();
            ByteBuffer result = ByteBuffer.allocate(1);
            socketChannel.read(result);
            socketChannel.close();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }
}

