/*
 * Decompiled with CFR 0.152.
 */
package csfs.impl;

import csfs.impl.FileServerImpl;
import csfs.impl.RemoteFileDefaultServantImpl;
import csfs.impl.channel.NullWriteChannelDefaultServantImpl;
import csfs.impl.channel.RandomAccessChannelDefaultServantImpl;
import csfs.impl.channel.ReadChannelDefaultServantImpl;
import csfs.impl.channel.WriteChannelDefaultServantImpl;
import csfs.impl.util.SystemProperties;
import csfs.impl.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.ImplicitActivationPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import org.omg.PortableServer.ThreadPolicyValue;

public class Server {
    public static void main(String[] args) throws Exception {
        String rootDirLocalFileSeparator;
        File rootDirFile;
        String port;
        Properties orbProperties = new Properties();
        orbProperties.load(Server.class.getResourceAsStream("/orb_init.properties"));
        for (String arg : args) {
            if (!arg.startsWith("--")) continue;
            int index = arg.indexOf(61);
            SystemProperties.setProperty(arg.substring(2, index), arg.substring(index + 1));
        }
        String hostName = SystemProperties.getProperty("HOST");
        if (hostName == null) {
            hostName = orbProperties.getProperty("OAIAddr");
            if (hostName == null) {
                System.err.println("O host n\u201eo foi informado.");
                System.exit(-1);
            }
        } else {
            orbProperties.setProperty("OAIAddr", hostName);
        }
        if ((port = SystemProperties.getProperty("PORT")) == null) {
            port = orbProperties.getProperty("OAPort");
            if (port == null) {
                System.err.println("A porta n\u201eo foi informada.");
                System.exit(-1);
            }
        } else {
            orbProperties.setProperty("OAPort", port);
        }
        String implName = "CSFSMgr" + hostName + port;
        orbProperties.setProperty("jacorb.implname", implName);
        String rootDir = SystemProperties.getProperty("ROOT_DIR");
        if (rootDir == null) {
            System.err.println("ROOT_DIR n\u201eo foi informado.");
            System.exit(-1);
        }
        if (!(rootDirFile = new File(rootDirLocalFileSeparator = Util.systemFileSeparatorToLocalFileSeparator(rootDir))).exists()) {
            System.err.println("ROOT_DIR: " + rootDirLocalFileSeparator + " n\u201eo existe!!");
            System.exit(-1);
        }
        if (!rootDirFile.isDirectory()) {
            System.err.println("ROOT_DIR: " + rootDirLocalFileSeparator + " n\u201eo \u00c8 diret\u00dbrio!!");
            System.exit(-1);
        }
        rootDir = rootDirFile.getCanonicalPath();
        SystemProperties.setProperty("CANONICAL_ROOT_DIR", rootDir);
        SimpleFormatter f = new SimpleFormatter();
        FileHandler h = new FileHandler(SystemProperties.getProperty("SERVER_LOG"));
        h.setFormatter(f);
        Logger.global.addHandler(h);
        Logger.global.setUseParentHandlers(false);
        ORB orb = ORB.init((String[])args, (Properties)orbProperties);
        POA rootPOA = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        Policy[] fileServerPolicies = new Policy[]{rootPOA.create_thread_policy(ThreadPolicyValue.ORB_CTRL_MODEL), rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.UNIQUE_ID), rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), rootPOA.create_implicit_activation_policy(ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION), rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY)};
        POA fileServerPOA = rootPOA.create_POA("FileServerPOA", null, fileServerPolicies);
        for (Policy fileServerPolicie : fileServerPolicies) {
            fileServerPolicie.destroy();
        }
        FileServerImpl servant = new FileServerImpl(SystemProperties.getProperty("ROOT_DIR"));
        fileServerPOA.activate_object_with_id("FileServer".getBytes(), (Servant)servant);
        Object fileServerObj = fileServerPOA.servant_to_reference((Servant)servant);
        PrintWriter pw = new PrintWriter(new FileWriter(args[0]));
        pw.println(orb.object_to_string(fileServerObj));
        pw.flush();
        pw.close();
        Policy[] policies = new Policy[]{rootPOA.create_thread_policy(ThreadPolicyValue.ORB_CTRL_MODEL), rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.UNIQUE_ID), rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), rootPOA.create_implicit_activation_policy(ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION), rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT)};
        POA remoteFileDefaultServantPOA = rootPOA.create_POA("RemoteFileDefaultServantPOA", null, policies);
        for (Policy policie : policies) {
            policie.destroy();
        }
        RemoteFileDefaultServantImpl remoteFileServant = new RemoteFileDefaultServantImpl(SystemProperties.getProperty("ROOT_DIR"), servant);
        remoteFileDefaultServantPOA.set_servant((Servant)remoteFileServant);
        Policy[] channelPolicies = new Policy[]{remoteFileDefaultServantPOA.create_thread_policy(ThreadPolicyValue.ORB_CTRL_MODEL), remoteFileDefaultServantPOA.create_lifespan_policy(LifespanPolicyValue.TRANSIENT), remoteFileDefaultServantPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.UNIQUE_ID), remoteFileDefaultServantPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), remoteFileDefaultServantPOA.create_implicit_activation_policy(ImplicitActivationPolicyValue.NO_IMPLICIT_ACTIVATION), remoteFileDefaultServantPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), remoteFileDefaultServantPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT)};
        POA readChannelDefaultServantPOA = remoteFileDefaultServantPOA.create_POA("ReadChannelDefaultServantPOA", null, channelPolicies);
        ReadChannelDefaultServantImpl readChannelServant = new ReadChannelDefaultServantImpl();
        readChannelDefaultServantPOA.set_servant((Servant)readChannelServant);
        POA writeChannelDefaultServantPOA = remoteFileDefaultServantPOA.create_POA("WriteChannelDefaultServantPOA", null, channelPolicies);
        WriteChannelDefaultServantImpl writeChannelServant = new WriteChannelDefaultServantImpl();
        writeChannelDefaultServantPOA.set_servant((Servant)writeChannelServant);
        POA randomAccessChannelDefaultServantPOA = remoteFileDefaultServantPOA.create_POA("RandomAccessChannelDefaultServantPOA", null, channelPolicies);
        RandomAccessChannelDefaultServantImpl randomAccessChannelServant = new RandomAccessChannelDefaultServantImpl();
        randomAccessChannelDefaultServantPOA.set_servant((Servant)randomAccessChannelServant);
        POA nullWriteChannelDefaultServantPOA = remoteFileDefaultServantPOA.create_POA("NullWriteChannelDefaultServantPOA", null, channelPolicies);
        NullWriteChannelDefaultServantImpl nullWriteChannelServant = new NullWriteChannelDefaultServantImpl();
        nullWriteChannelDefaultServantPOA.set_servant((Servant)nullWriteChannelServant);
        for (Policy channelPolicie : channelPolicies) {
            channelPolicie.destroy();
        }
        rootPOA.the_POAManager().activate();
        fileServerPOA.the_POAManager().activate();
        remoteFileDefaultServantPOA.the_POAManager().activate();
        readChannelDefaultServantPOA.the_POAManager().activate();
        writeChannelDefaultServantPOA.the_POAManager().activate();
        randomAccessChannelDefaultServantPOA.the_POAManager().activate();
        nullWriteChannelDefaultServantPOA.the_POAManager().activate();
        Logger.global.info("ROOT_DIR = " + SystemProperties.getProperty("ROOT_DIR"));
        Logger.global.info("CANONICAL_ROOT_DIR = " + SystemProperties.getProperty("CANONICAL_ROOT_DIR"));
        Logger.global.info("OAIAddr = " + hostName);
        Logger.global.info("OAPort = " + port);
        orb.run();
    }
}

