/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.TraversalCheckingVisitor;

public class MethodCallingVisitor
extends TraversalCheckingVisitor
implements Serializable {
    private transient Method method;
    private final Object[] arguments;
    private final Class type;
    private final boolean visitInInstantiationOrder;
    private final List componentInstances;

    public MethodCallingVisitor(Method method, Class clazz, Object[] objectArray, boolean bl) {
        if (method == null) {
            throw new NullPointerException();
        }
        this.method = method;
        this.arguments = objectArray;
        this.type = clazz;
        this.visitInInstantiationOrder = bl;
        this.componentInstances = new ArrayList();
    }

    public MethodCallingVisitor(Method method, Class clazz, Object[] objectArray) {
        this(method, clazz, objectArray, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object traverse(Object object) {
        this.componentInstances.clear();
        try {
            super.traverse(object);
            if (!this.visitInInstantiationOrder) {
                Collections.reverse(this.componentInstances);
            }
            Iterator iterator = this.componentInstances.iterator();
            while (iterator.hasNext()) {
                this.invoke(iterator.next());
            }
        }
        finally {
            this.componentInstances.clear();
        }
        return Void.TYPE;
    }

    public void visitContainer(PicoContainer picoContainer) {
        super.visitContainer(picoContainer);
        this.componentInstances.addAll(picoContainer.getComponentInstancesOfType(this.type));
    }

    protected Method getMethod() {
        return this.method;
    }

    protected Object[] getArguments() {
        return this.arguments;
    }

    protected void invoke(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.invoke(objectArray[i]);
        }
    }

    protected Object invoke(Object object) {
        Method method = this.getMethod();
        try {
            method.invoke(object, this.getArguments());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new PicoIntrospectionException("Can't call " + method.getName() + " on " + object, illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PicoIntrospectionException("Can't call " + method.getName() + " on " + object, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PicoIntrospectionException("Failed when calling " + method.getName() + " on " + object, invocationTargetException.getTargetException());
        }
        return Void.TYPE;
    }
}

