#include "wioapiimpl.h"


// ------------------------------------------------------------------------

// ........................................................................

wioapi::Exception::Exception(const char* method_name, 
const char* client_message, const char* server_message) {
   const char* nil = "---";

   if (method_name != NULL) this->method_name = strdup(method_name);
   else method_name = strdup(nil);

   if (server_message != NULL) this->server_message = strdup(server_message);
   else server_message = strdup(nil);

   if (client_message != NULL) this->client_message = strdup(client_message);
   else client_message = strdup(nil);
}

// ........................................................................

const char* wioapi::Exception::getClientMessage(void) {
   return client_message;
}

// ........................................................................

const char* wioapi::Exception::getServerMessage(void) {
   return server_message;
}

// ........................................................................

const char* wioapi::Exception::getMethodName(void) {
   return method_name;
}

// ........................................................................

wioapi::Exception::~Exception() {
   if (server_message != NULL) free(server_message); 
   server_message = NULL;
   if (client_message != NULL) free(client_message); 
   client_message = NULL;
   if (method_name != NULL) free(method_name); 
   method_name = NULL;
}

