package csdk.v1_0.helper.command.parameters;

/**
 * Base genrica para o valor de um parmetro.
 * 
 * @param <T> o tipo do valor do parmetro.
 */
public abstract class AbstractParameterValue<T> implements IParameterValue<T> {

  /** O valor. */
  private T value;

  /**
   * Construtor.
   * 
   * @param value o valor do parmetro.
   */
  public AbstractParameterValue(T value) {
    this.value = value;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public T getValue() {
    return value;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getValueAsString() throws ParameterValueConvertionException {
    ParameterValueConverter<T> valueConverter = getValueConverter();
    if (valueConverter != null) {
      return valueConverter.getValueAsString(value);
    }
    return null;
  }

  /**
   * Obtm o conversor do tipo <T> do valor para string.
   * 
   * @return value o conversor.
   */
  protected ParameterValueConverter<T> getValueConverter() {
    return new DefaultValueConverter<T>();
  }

  /**
   * Atribui o valor do parmetro.
   * 
   * @param value o valor.
   */
  protected void setValue(T value) {
    this.value = value;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return String.valueOf(value);
  }
}

/**
 * Conversor padro, que simplesmente repassa o valor do objeto em
 * {@link String}.
 * 
 * @param <T> o tipo do valor a ser convertido.
 */
class DefaultValueConverter<T> implements ParameterValueConverter<T> {

  /**
   * {@inheritDoc}
   */
  @Override
  public String getValueAsString(T obj)
    throws ParameterValueConvertionException {
    if (obj == null) {
      return null;
    }
    return String.valueOf(obj);
  }

}