package csdk.v1_0.helper.application;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

/**
 * Classe de internacionalizao dos componentes do Helper CSDK.
 * 
 * @author Tecgraf
 */
public class HelperBundle {

  /** Bundles j carregados */
  private static final Map<Locale, Properties> bundles =
    new HashMap<Locale, Properties>();

  /**
   * Obtm a string internacionalizada para o locale especificado.
   * 
   * @param locale o locale.
   * @param clazz a classe.
   * @param tag a chave de internacionalizao.
   * @return a string internacionalizada.
   */
  public static String getString(Locale locale, Class<?> clazz, String tag) {
    Properties bundle = null;
    if (bundles.containsKey(locale)) {
      bundle = bundles.get(locale);
    }
    else {
      bundle = loadBundle(locale);
      if (bundle != null) {
        bundles.put(locale, bundle);
      }
    }
    if (bundle == null) {
      return "<" + tag + ">";
    }
    String key = clazz.getSimpleName() + "." + tag;
    Object value = bundle.get(key);
    if (value == null) {
      return "<<" + tag + ">>";
    }
    return (String) value;
  }

  /**
   * Carrega o bundle de internacionalizao do Locale especificado.
   * 
   * @param locale o locale
   * @return o bundle.
   */
  private static Properties loadBundle(Locale locale) {
    Properties bundle = new Properties();
    String lang = locale.getLanguage();
    String country = locale.getCountry();
    String resourceDir = "resources";
    String fileName = "idiom_" + lang + "_" + country + ".properties";
    String path = resourceDir + "/" + fileName;
    InputStream inStream = HelperBundle.class.getResourceAsStream(path);
    try {
      if (inStream != null) {
        bundle.load(inStream);
        return bundle;
      }
      else {
        return null;
      }
    }
    catch (IOException e) {
      return null;
    }
    finally {
      try {
        if (inStream != null) {
          inStream.close();
        }
      }
      catch (IOException e) {
        return null;
      }
    }
  }

}
