package csdk.v2.rest.helper;

import csdk.v2.extras.context.rest.IRestContext;
import csdk.v2.extras.context.rest.RestException;
import csdk.v2.helper.application.AbstractApplication;
import org.glassfish.jersey.server.ResourceConfig;

import java.util.List;

/**
 * Controlador bsico de registro de recurso de aplicaes
 *
 * @param <A> classe da aplicao.
 */
public abstract class ApplicationRestController<A extends AbstractApplication> {

  /**
   * Aplicao.
   */
  private final A application;

  /**
   * Construtor
   *
   * @param application aplicao.
   */
  public ApplicationRestController(A application) {
    this.application = application;
  }

  /**
   * Registro dos objetos definidos para recursos REST ({@link #getResources()}
   *
   * @throws RestException em caso de falha no regitro.
   */
  public void register() throws RestException {
    IRestContext context = application.getContext(IRestContext.class);
    ResourceConfig rc = new ResourceConfig();
    rc.registerInstances(getResources().toArray());
    context.registerResources(rc);
  }

  /**
   * Consulta  aplicao.
   *
   * @return aplicao.
   */
  public A getApplication() {
    return application;
  }

  /**
   * Consulta a lista de objetos de recursos que devem ser registrados pela
   * instncia da aplicao.
   *
   * @return lista
   */
  public abstract List<ApplicationRestResource<A>> getResources();

}
