package csdk.v2.runner;

import java.text.MessageFormat;

/**
 * Exceo padro lanada pelo Runner CSDK.
 */
public class RunnerException extends RuntimeException {

  /**
   * Construtor.
   *
   * @param cause causa do erro.
   * @param message mensagem de erro.
   * @param args argumentos de formatao da mensagem de erro.
   */
  public RunnerException(Throwable cause, String message, Object... args) {
    super(MessageFormat.format(message, args), cause);
  }

  /**
   * Construtor
   *
   * @param message mensagem de erro.
   * @param args argumentos de formatao da mensagem de erro.
   */
  public RunnerException(String message, Object... args) {
    super(MessageFormat.format(message, args));
  }

  /**
   * Construtor
   *
   * @param cause causa do erro.
   */
  public RunnerException(Throwable cause) {
    super(cause);
  }

  /**
   * Construtor.
   */
  protected RunnerException() {
    super();
  }

}
