package csdk.v2.runner.rest;

import org.glassfish.jersey.server.ResourceConfig;

import csdk.v2.extras.context.rest.IRestContext;
import csdk.v2.extras.context.rest.RestException;
import csdk.v2.runner.ApplicationRegistry;
import csdk.v2.runner.core.AbstractContext;

/**
 * Implementao do contexto de usurios para o Runner.
 *
 * @author Tecgraf
 **/
public class RestContext extends AbstractContext implements IRestContext {

  /**
   * Prefixo para recursos REST.
   */
  private final String prefix;

  /**
   * Construtor.
   *
   * @param instanceId identificador da instncia da aplicao.
   * @param registry registro da aplicao.
   */
  public RestContext(String instanceId, ApplicationRegistry registry) {
    this.prefix = registry.getApplicationId() + "/" + instanceId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void registerResources(
    ResourceConfig resourceConfig) throws RestException {
    RestController restController = RestController.getInstance();
    if (!resourceConfig.getInstances().isEmpty() && resourceConfig
      .getClasses().isEmpty()) {
      restController
        .addApplicationResources(prefix, resourceConfig);
    }
    else {
      String error =
        "Failed to register instances from the provided ResourceConfig as " +
          "REST resources. Check for classes or packages wrongly registered " +
          "on ResourceConfig, since only instances are allowed.";
      throw new RestException(error);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void unregisterResources() {
    RestController restController = RestController.getInstance();
    restController.removeApplicationResources(prefix);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void contextDeactivated() {
    unregisterResources();
  }
}
