package csdk.v1_0.runner.application;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import csdk.v1_0.api.application.IApplicationContext;
import csdk.v1_0.api.core.IContext;
import csdk.v1_0.api.filesystem.local.ILocalFileSystemContext;
import csdk.v1_0.runner.ApplicationRegistry;
import csdk.v1_0.runner.IContextFactory;
import csdk.v1_0.runner.filesystem.local.LocalFileSystemContext;

/**
 * Fbrica padro de contextos do Runner.
 */
public class DefaultContextFactory implements IContextFactory {

  /**
   * {@inheritDoc}
   */
  @Override
  public Map<Class<? extends IContext>, IContext> createCSDKContexts(
    String instanceId, ApplicationRegistry registry, Properties properties) {
    Map<Class<? extends IContext>, IContext> contexts =
      new HashMap<Class<? extends IContext>, IContext>();
    contexts.put(IApplicationContext.class, new ApplicationContext(instanceId,
      registry));
    contexts.put(ILocalFileSystemContext.class, new LocalFileSystemContext());
    return contexts;
  }

}
