/*
 * Decompiled with CFR 0.152.
 */
package csdk.v1_0.runner.filesystem;

import csdk.v1_0.runner.filesystem.FileTypes;
import java.util.ArrayList;

public class FileType {
    private final String name;
    private final ArrayList<String> extensions = new ArrayList();

    public ArrayList<String> getExtensions() {
        return this.extensions;
    }

    public void addExtension(String extension) {
        FileType type = FileTypes.getFileTypeFromExtension(extension);
        if (type != null) {
            String err = "Extension " + extension + " is already assigned to type: " + type;
            throw new IllegalArgumentException(err);
        }
        this.extensions.add(extension);
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public FileType(String type) {
        if (type == null) {
            throw new IllegalArgumentException("Internal error: Type cannot be null.");
        }
        this.name = type.trim().toUpperCase();
    }
}

