package brickbreaker;

import javafx.scene.Group;

public class MainController {

  // Instance of scene root node
  private Group root;

  // Instance of splash (if exists)
  private Splash splash;

  // Instance of level (if exists)
  private Level level;

  // Number of lifes
  private int lifeCount;

  // Current score
  private int score;

  public MainController(Group root) {
    this.root = root;
  }

  public int getState() {
    return state;
  }

  public int getScore() {
    return score;
  }

  public void setScore(int score) {
    this.score = score;
  }

  public int getLifeCount() {
    return lifeCount;
  }

  public void increaseLives() {
    lifeCount = Math.min(lifeCount + 1, Config.MAX_LIVES);
  }

  public void decreaseLives() {
    lifeCount--;
  }

  // Initializes game (lifes, scores etc)
  public void startGame() {
    lifeCount = 3;
    score = 0;
    changeState(1);
  }

  // Current state of the game. The next values are available
  // 0 - Splash
  public static final int SPLASH = 0;
  // 1..Level.LEVEL_COUNT - Level
  private int state = SPLASH;

  public void changeState(int newState) {
    this.state = newState;
    if (splash != null) {
      splash.stop();
    }
    if (level != null) {
      level.stop();
    }
    if (state < 1 || state > LevelData.getLevelsCount()) {
      root.getChildren().remove(level);
      level = null;
      splash = new Splash(this);
      root.getChildren().add(splash);
      splash.start();
    }
    else {
      root.getChildren().remove(splash);
      splash = null;
      level = new Level(state, this);
      root.getChildren().add(level);
      level.start();
    }
  }

}
