/*
 * Decompiled with CFR 0.152.
 */
package csdk.v2.runner;

import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.application.IMessage;
import csdk.v2.api.application.IMessageSender;
import csdk.v2.runner.ApplicationRegistry;
import csdk.v2.runner.CSDKLogger;
import csdk.v2.runner.IContextFactory;
import csdk.v2.runner.application.DefaultContextFactory;
import csdk.v2.runner.application.RunnerApplication;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ApplicationManager {
    private static ApplicationManager instance;
    private final Map<String, RunnerApplication> activeApplications = new HashMap<String, RunnerApplication>();
    private final Hashtable<String, ApplicationRegistry> registries = new Hashtable();
    private IContextFactory contextFactory = new DefaultContextFactory();
    private final Properties contextProperties = new Properties();

    private ApplicationManager() {
    }

    public static ApplicationManager getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new ApplicationManager();
        return instance;
    }

    public void finishAllApplications() {
        Collection<RunnerApplication> values = this.activeApplications.values();
        values.removeIf(RunnerApplication::finishApplication);
    }

    public void finishApplication(String instanceId) throws ApplicationException {
        RunnerApplication application = this.activeApplications.get(instanceId);
        if (application != null && !application.finishApplication()) {
            throw new ApplicationException("Application could not be terminaded: " + instanceId);
        }
    }

    private void activate(RunnerApplication application) {
        String id = application.getInstanceId();
        CSDKLogger logger = CSDKLogger.getInstance();
        logger.logSevere("Application {0} activated.", id);
        this.activeApplications.put(id, application);
    }

    public void addApplicationRegistry(ApplicationRegistry reg) {
        String applicationId = reg.getApplicationId();
        if (this.registries.containsKey(applicationId)) {
            throw new IllegalArgumentException("Id already registered.");
        }
        this.registries.put(applicationId, reg);
    }

    public void setContextFactory(IContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public IContextFactory getContextFactory() {
        return this.contextFactory;
    }

    public Set<String> getAllAplicationsIds() {
        return this.registries.keySet();
    }

    public ApplicationRegistry getApplicationRegistry(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Invalid null id.");
        }
        if (this.registries.containsKey(id)) {
            return this.registries.get(id);
        }
        return null;
    }

    public boolean hasApplicationRegistry(String id) {
        if (id == null) {
            return false;
        }
        return this.registries.containsKey(id);
    }

    public RunnerApplication getRunningApp(String id) {
        return this.activeApplications.get(id);
    }

    public RunnerApplication getRunningApplicationType(String id) {
        for (RunnerApplication app : this.activeApplications.values()) {
            if (!app.getApplicationId().equals(id)) continue;
            return app;
        }
        return null;
    }

    public boolean hasActiveApplications() {
        return this.activeApplications.size() != 0;
    }

    public Properties getRunnerProperties() {
        return this.contextProperties;
    }

    public void deactivate(RunnerApplication application) {
        CSDKLogger logger = CSDKLogger.getInstance();
        String id = application.getInstanceId();
        logger.logSevere("Application {0} deactivated.", id);
        this.activeApplications.remove(id);
    }

    public RunnerApplication runApplication(String id) {
        ApplicationRegistry reg = this.getApplicationRegistry(id);
        CSDKLogger logger = CSDKLogger.getInstance();
        if (reg == null) {
            logger.logSevere("No application {0} found!", id);
            return null;
        }
        try {
            logger.logSevere("Launching new application {0}...", id);
            RunnerApplication runningApp = this.getRunningApplicationType(id);
            if (reg.isSingleton() && runningApp != null) {
                return runningApp;
            }
            RunnerApplication wrapperApp = new RunnerApplication(reg);
            wrapperApp.onApplicationStart();
            this.activate(wrapperApp);
            return wrapperApp;
        }
        catch (Exception e) {
            logger.logException(e);
            return null;
        }
    }

    public Object sendSyncMessage(String id, IMessage message, IMessageSender sender) {
        RunnerApplication app = this.getRunningApp(id);
        if (app != null) {
            return app.onSyncMessageReceived(message, sender);
        }
        return null;
    }

    public void sendAsyncMessage(String id, IMessage message, IMessageSender sender) {
        RunnerApplication app = this.getRunningApp(id);
        if (app != null) {
            Runnable r = () -> app.onAsyncMessageReceived(message, sender);
            new Thread(r).start();
        }
    }

    public void broadcastAsyncMessage(IMessage message, IMessageSender sender) {
        for (String destinationId : this.getAllAplicationsIds()) {
            if (destinationId.equals(sender.getApplicationInstanceId())) continue;
            this.sendAsyncMessage(destinationId, message, sender);
        }
    }

    public void addContextProperties(Properties props) {
        this.contextProperties.putAll((Map<?, ?>)props);
    }

    public boolean isApplicationRunning(String instanceId) {
        return this.activeApplications.containsKey(instanceId);
    }
}

