package screensframework;

import java.awt.Dimension;

import javax.swing.JFrame;

import csdk.v2.fx.helper.AbstractJFXApplication;
import csdk.v2.api.application.ApplicationException;
import csdk.v2.api.core.ICSDKEnvironment;
import javafx.scene.Group;
import javafx.scene.Parent;

public class FXScreensApplication extends AbstractJFXApplication {

  public static String screen1ID = "main";
  public static String screen1File = "Screen1.fxml";
  public static String screen2ID = "screen2";
  public static String screen2File = "Screen2.fxml";
  public static String screen3ID = "screen3";
  public static String screen3File = "Screen3.fxml";

  /**
   * Construtor.
   *
   * @param csdkInterface interface
   */
  public FXScreensApplication(ICSDKEnvironment csdkInterface) {
    super(csdkInterface);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void applicationEnded() throws ApplicationException {
    // vazio
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void applicationStarted(JFrame mainFrame)
    throws ApplicationException {
    mainFrame.setSize(new Dimension(200, 150));
    mainFrame.setLocationRelativeTo(null); // centralizar
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Parent getParentNode() throws Exception {
    ScreensController mainContainer = new ScreensController();
    mainContainer.loadScreen(ScreensFramework.screen1ID,
      ScreensFramework.screen1File);
    mainContainer.loadScreen(ScreensFramework.screen2ID,
      ScreensFramework.screen2File);
    mainContainer.loadScreen(ScreensFramework.screen3ID,
      ScreensFramework.screen3File);
    mainContainer.setScreen(ScreensFramework.screen1ID);
    Group root = new Group();
    root.getChildren().addAll(mainContainer);
    return root;
  }
}
