/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.print;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.List;
import tecgraf.javautils.gui.print.PrintConfiguration;
import tecgraf.javautils.gui.print.PrintableChartPanel;
import tecgraf.javautils.gui.print.PrintableReportItem;

public class PrintableChart
implements PrintableReportItem {
    private PrintableChartPanel chartPanel;
    private float height;
    private float width;
    private List<PrintableReportItem> otherPageItems;
    private float heightRatio;
    private float widthRatio;
    private float yPaperLandscape;

    public PrintableChart(PrintableChartPanel chartPanel, List<PrintableReportItem> otherPageItems) {
        if (otherPageItems == null) {
            throw new IllegalArgumentException("otherPageItems == null");
        }
        this.chartPanel = chartPanel;
        this.otherPageItems = otherPageItems;
    }

    public PrintableChart(PrintableChartPanel chartPanel, float heightRatio, float widthRatio) {
        this.chartPanel = chartPanel;
        if (heightRatio < 0.0f || heightRatio > 1.0f) {
            throw new IllegalArgumentException("heightRatio \u00e9 uma fra\u00e7\u00e3o entre 0 e 1");
        }
        if (widthRatio < 0.0f || widthRatio > 1.0f) {
            throw new IllegalArgumentException("widthRatio \u00e9 uma fra\u00e7\u00e3o entre 0 e 1");
        }
        this.heightRatio = heightRatio;
        this.widthRatio = widthRatio;
    }

    @Override
    public boolean simulatePrint(Graphics2D g2, PageFormat format, int pageIndex) {
        return this.print(g2, format, pageIndex);
    }

    @Override
    public boolean print(Graphics2D g2, PageFormat pageFormat, int pageIndex) {
        if (this.otherPageItems == null) {
            this.height = (float)pageFormat.getImageableHeight() * this.heightRatio;
            this.width = (float)pageFormat.getImageableWidth() * this.widthRatio;
            this.yPaperLandscape = (float)pageFormat.getPaper().getImageableY() + (float)pageFormat.getImageableWidth() - this.width;
        } else {
            this.yPaperLandscape = (float)pageFormat.getImageableX();
            this.height = (float)pageFormat.getImageableHeight() - this.getOthersHeight(g2, pageFormat, pageIndex) - 1.0f;
            this.width = (float)pageFormat.getImageableWidth();
        }
        double x = pageFormat.getOrientation() != 0 ? pageFormat.getImageableX() : pageFormat.getImageableY();
        double y = pageFormat.getOrientation() != 0 ? pageFormat.getImageableY() : (double)this.yPaperLandscape;
        double paperWidth = pageFormat.getOrientation() != 0 ? (double)this.width : (double)this.height;
        double paperHeight = pageFormat.getOrientation() != 0 ? (double)this.height : (double)this.width;
        Paper paper = pageFormat.getPaper();
        paper.setImageableArea(x, y, paperWidth, paperHeight);
        PageFormat graphicPageFormat = (PageFormat)pageFormat.clone();
        graphicPageFormat.setPaper(paper);
        Paint oldColor = this.chartPanel.getBackgroundPaint();
        this.chartPanel.setBackgroundPaint(Color.white);
        AffineTransform affineTransform = g2.getTransform();
        Shape clip = g2.getClip();
        this.chartPanel.print(g2, graphicPageFormat);
        g2.setTransform(affineTransform);
        g2.setClip(clip);
        this.chartPanel.setBackgroundPaint(oldColor);
        return true;
    }

    private float getOthersHeight(Graphics2D g2, PageFormat pageFormat, int pageIndex) {
        float height = 0.0f;
        for (PrintableReportItem printable : this.otherPageItems) {
            printable.simulatePrint(g2, pageFormat, pageIndex);
            height += printable.getHeight();
        }
        return height;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public void initPrinting(PrintConfiguration configuration) {
    }

    @Override
    public float getWidth() {
        return this.width;
    }
}

