package snakegame.algorithm.util;

import snakegame.map.Direction;

/**
 * Distncia em {@link Integer}.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class DeltaInt implements Comparable<DeltaInt> {

  /** Distncia. */
  private int distance;

  /** Direo. */
  private Direction direction;

  /**
   * Candidato.
   * 
   * @param distance distncia.
   * @param direction direo.
   */
  public DeltaInt(int distance, Direction direction) {
    if (distance < 0) {
      throw new IllegalArgumentException("distance no pode ser negativa.");
    }
    if (direction == null) {
      throw new IllegalArgumentException("direction no pode ser nulo.");
    }
    this.distance = distance;
    this.direction = direction;
  }

  /**
   * Distncia.
   * 
   * @return distncia.
   */
  public int getDistance() {
    return distance;
  }

  /**
   * Direo.
   * 
   * @return direo.
   */
  public Direction getDirection() {
    return direction;
  }

  /** {@inheritDoc} */
  @Override
  public int compareTo(DeltaInt other) {
    if (distance < other.distance) {
      return -1;
    }
    else if (distance > other.distance) {
      return 1;
    }
    return 0;
  }
}
