package snakegame.session.listener;

import snakegame.algorithm.IMoveAlgorithm;

/**
 * Ouvinte que sinaliza que o estado do jogo foi alterado.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface ModeChangedListener {

  /**
   * Jogo comeou.
   * 
   * @param algorithm algoritmo.
   */
  void modeOn(IMoveAlgorithm algorithm);

  /** Jogo terminou. */
  void modeOff();
}
