package snakegame.action;

import java.awt.event.ActionEvent;

import snakegame.SnakeGame;
import snakegame.algorithm.IMoveAlgorithm;
import snakegame.session.Mode;
import snakegame.session.Session;
import csdk.v2.helper.application.AbstractApplicationAction;
import csdk.v2.helper.application.ApplicationImages;

/**
 * Ao que inicia o jogo.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class PlayAction extends AbstractApplicationAction<SnakeGame> {

  /** Sesso. */
  private Session session;

  /** Algoritmo. */
  private IMoveAlgorithm algorithm;

  /**
   * Construtor.
   * 
   * @param application aplicao.
   * @param session sesso.
   * @param algorithm algoritmo.
   */
  public PlayAction(SnakeGame application, Session session,
    IMoveAlgorithm algorithm) {
    super(application);

    if (algorithm == null) {
      setName(getClassString("name"));
    }
    else {
      String simpleName = algorithm.getClass().getSimpleName();
      String key = String.format("%s.name", simpleName);
      setName(getString(key));
    }
    setIcon(ApplicationImages.ICON_PLAY_16);

    this.session = session;
    this.algorithm = algorithm;
  }

  /** {@inheritDoc} */
  @Override
  public void actionPerformed(ActionEvent event) {
    session.setAlgorithm(algorithm);
    session.setMode(Mode.ON);
  }
}
